// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The basic information for term categorization. </summary>
    public partial class AtlasTermCategorizationHeader
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasTermCategorizationHeader"/>. </summary>
        public AtlasTermCategorizationHeader()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AtlasTermCategorizationHeader"/>. </summary>
        /// <param name="categoryGuid"> The GUID of the category. </param>
        /// <param name="description"> The description of the record. </param>
        /// <param name="displayText"> The display text. </param>
        /// <param name="relationGuid"> The GUID of the relationship. </param>
        /// <param name="status"> The status of term relationship. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasTermCategorizationHeader(Guid? categoryGuid, string description, string displayText, Guid? relationGuid, AtlasTermRelationshipStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CategoryGuid = categoryGuid;
            Description = description;
            DisplayText = displayText;
            RelationGuid = relationGuid;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The GUID of the category. </summary>
        public Guid? CategoryGuid { get; set; }
        /// <summary> The description of the record. </summary>
        public string Description { get; set; }
        /// <summary> The display text. </summary>
        public string DisplayText { get; set; }
        /// <summary> The GUID of the relationship. </summary>
        public Guid? RelationGuid { get; set; }
        /// <summary> The status of term relationship. </summary>
        public AtlasTermRelationshipStatus? Status { get; set; }
    }
}
