// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary>
    /// AtlasRelationshipDef is a TypeDef that defines a relationship.
    /// As with other typeDefs the AtlasRelationshipDef has a name. Once created the
    /// RelationshipDef has a guid.
    /// The name and the guid are the 2 ways that the
    /// RelationshipDef is identified.
    /// RelationshipDefs have 2 ends, each of which
    /// specify cardinality, an EntityDef type name and name and optionally
    /// whether the
    /// end is a container.
    /// RelationshipDefs can have AttributeDefs - though only
    /// primitive types are allowed.
    /// RelationshipDefs have a relationshipCategory
    /// specifying the UML type of relationship required
    /// The way EntityDefs and
    /// RelationshipDefs are intended to be used is that EntityDefs will define
    /// AttributeDefs these AttributeDefs
    /// will not specify an EntityDef type name as
    /// their types.
    /// RelationshipDefs introduce new attributes to the entity
    /// instances. For example
    /// EntityDef A might have attributes attr1,attr2,attr3
    ///
    /// EntityDef B might have attributes attr4,attr5,attr6
    /// RelationshipDef
    /// AtoB might define 2 ends
    ///
    /// end1:  type A, name attr7
    /// end2:  type B, name attr8
    ///
    /// When an instance of EntityDef A is created, it
    /// will have attributes attr1,attr2,attr3,attr7
    /// When an instance of EntityDef
    /// B is created, it will have attributes attr4,attr5,attr6,attr8
    ///
    /// In this way
    /// relationshipDefs can be authored separately from entityDefs and can inject
    /// relationship attributes into
    /// the entity instances
    /// </summary>
    public partial class AtlasRelationshipDef
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasRelationshipDef"/>. </summary>
        public AtlasRelationshipDef()
        {
            Options = new ChangeTrackingDictionary<string, string>();
            AttributeDefs = new ChangeTrackingList<AtlasAttributeDef>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasRelationshipDef"/>. </summary>
        /// <param name="category"> The enum of type category. </param>
        /// <param name="createTime"> The created time of the record. </param>
        /// <param name="createdBy"> The user who created the record. </param>
        /// <param name="dateFormatter"> The date format. </param>
        /// <param name="description"> The description of the type definition. </param>
        /// <param name="guid"> The GUID of the type definition. </param>
        /// <param name="name"> The name of the type definition. </param>
        /// <param name="options"> The options for the type definition. </param>
        /// <param name="serviceType"> The service type. </param>
        /// <param name="typeVersion"> The version of the type. </param>
        /// <param name="updateTime"> The update time of the record. </param>
        /// <param name="updatedBy"> The user who updated the record. </param>
        /// <param name="version"> The version of the record. </param>
        /// <param name="lastModifiedTS"> ETag for concurrency control. </param>
        /// <param name="attributeDefs"> An array of attribute definitions. </param>
        /// <param name="endDef1">
        /// The relationshipEndDef represents an end of the relationship. The end of the
        /// relationship is defined by a type, an
        /// attribute name, cardinality and whether
        /// it  is the container end of the relationship.
        /// </param>
        /// <param name="endDef2">
        /// The relationshipEndDef represents an end of the relationship. The end of the
        /// relationship is defined by a type, an
        /// attribute name, cardinality and whether
        /// it  is the container end of the relationship.
        /// </param>
        /// <param name="relationshipCategory">
        /// The Relationship category determines the style of relationship around
        /// containment and lifecycle.
        /// UML terminology is used for the values.
        /// ASSOCIATION is a relationship with no containment.
        /// COMPOSITION and AGGREGATION are containment relationships.
        /// The difference being in the lifecycles of the container and its children.
        /// In the COMPOSITION case, the children cannot exist without the container.
        /// For AGGREGATION, the life cycles of the container and children are totally independent.
        /// </param>
        /// <param name="relationshipLabel"> The label of the relationship. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasRelationshipDef(TypeCategory? category, long? createTime, string createdBy, AtlasDateFormat dateFormatter, string description, string guid, string name, IDictionary<string, string> options, string serviceType, string typeVersion, long? updateTime, string updatedBy, long? version, string lastModifiedTS, IList<AtlasAttributeDef> attributeDefs, AtlasRelationshipEndDef endDef1, AtlasRelationshipEndDef endDef2, RelationshipCategory? relationshipCategory, string relationshipLabel, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Category = category;
            CreateTime = createTime;
            CreatedBy = createdBy;
            DateFormatter = dateFormatter;
            Description = description;
            Guid = guid;
            Name = name;
            Options = options;
            ServiceType = serviceType;
            TypeVersion = typeVersion;
            UpdateTime = updateTime;
            UpdatedBy = updatedBy;
            Version = version;
            LastModifiedTS = lastModifiedTS;
            AttributeDefs = attributeDefs;
            EndDef1 = endDef1;
            EndDef2 = endDef2;
            RelationshipCategory = relationshipCategory;
            RelationshipLabel = relationshipLabel;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The enum of type category. </summary>
        public TypeCategory? Category { get; set; }
        /// <summary> The created time of the record. </summary>
        public long? CreateTime { get; set; }
        /// <summary> The user who created the record. </summary>
        public string CreatedBy { get; set; }
        /// <summary> The date format. </summary>
        public AtlasDateFormat DateFormatter { get; set; }
        /// <summary> The description of the type definition. </summary>
        public string Description { get; set; }
        /// <summary> The GUID of the type definition. </summary>
        public string Guid { get; set; }
        /// <summary> The name of the type definition. </summary>
        public string Name { get; set; }
        /// <summary> The options for the type definition. </summary>
        public IDictionary<string, string> Options { get; }
        /// <summary> The service type. </summary>
        public string ServiceType { get; set; }
        /// <summary> The version of the type. </summary>
        public string TypeVersion { get; set; }
        /// <summary> The update time of the record. </summary>
        public long? UpdateTime { get; set; }
        /// <summary> The user who updated the record. </summary>
        public string UpdatedBy { get; set; }
        /// <summary> The version of the record. </summary>
        public long? Version { get; set; }
        /// <summary> ETag for concurrency control. </summary>
        public string LastModifiedTS { get; set; }
        /// <summary> An array of attribute definitions. </summary>
        public IList<AtlasAttributeDef> AttributeDefs { get; }
        /// <summary>
        /// The relationshipEndDef represents an end of the relationship. The end of the
        /// relationship is defined by a type, an
        /// attribute name, cardinality and whether
        /// it  is the container end of the relationship.
        /// </summary>
        public AtlasRelationshipEndDef EndDef1 { get; set; }
        /// <summary>
        /// The relationshipEndDef represents an end of the relationship. The end of the
        /// relationship is defined by a type, an
        /// attribute name, cardinality and whether
        /// it  is the container end of the relationship.
        /// </summary>
        public AtlasRelationshipEndDef EndDef2 { get; set; }
        /// <summary>
        /// The Relationship category determines the style of relationship around
        /// containment and lifecycle.
        /// UML terminology is used for the values.
        /// ASSOCIATION is a relationship with no containment.
        /// COMPOSITION and AGGREGATION are containment relationships.
        /// The difference being in the lifecycles of the container and its children.
        /// In the COMPOSITION case, the children cannot exist without the container.
        /// For AGGREGATION, the life cycles of the container and children are totally independent.
        /// </summary>
        public RelationshipCategory? RelationshipCategory { get; set; }
        /// <summary> The label of the relationship. </summary>
        public string RelationshipLabel { get; set; }
    }
}
