// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Atlas relationship instance. </summary>
    public partial class AtlasRelationship
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasRelationship"/>. </summary>
        public AtlasRelationship()
        {
            Attributes = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasRelationship"/>. </summary>
        /// <param name="attributes"> The attributes of the struct. </param>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="lastModifiedTS"> ETag for concurrency control. </param>
        /// <param name="createTime"> The created time of the record. </param>
        /// <param name="createdBy"> The user who created the record. </param>
        /// <param name="end1"> Reference to an object-instance of a type - like entity. </param>
        /// <param name="end2"> Reference to an object-instance of a type - like entity. </param>
        /// <param name="guid"> The GUID of the relationship. </param>
        /// <param name="homeId"> The home ID of the relationship. </param>
        /// <param name="label"> The label of the relationship. </param>
        /// <param name="provenanceType"> Used to record the provenance of an instance of an entity or relationship. </param>
        /// <param name="status"> The enum of relationship status. </param>
        /// <param name="updateTime"> The update time of the record. </param>
        /// <param name="updatedBy"> The user who updated the record. </param>
        /// <param name="version"> The version of the relationship. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasRelationship(IDictionary<string, BinaryData> attributes, string typeName, string lastModifiedTS, long? createTime, string createdBy, AtlasObjectId end1, AtlasObjectId end2, string guid, string homeId, string label, int? provenanceType, StatusAtlasRelationship? status, long? updateTime, string updatedBy, long? version, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Attributes = attributes;
            TypeName = typeName;
            LastModifiedTS = lastModifiedTS;
            CreateTime = createTime;
            CreatedBy = createdBy;
            End1 = end1;
            End2 = end2;
            Guid = guid;
            HomeId = homeId;
            Label = label;
            ProvenanceType = provenanceType;
            Status = status;
            UpdateTime = updateTime;
            UpdatedBy = updatedBy;
            Version = version;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The attributes of the struct.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> Attributes { get; }
        /// <summary> The name of the type. </summary>
        public string TypeName { get; set; }
        /// <summary> ETag for concurrency control. </summary>
        public string LastModifiedTS { get; set; }
        /// <summary> The created time of the record. </summary>
        public long? CreateTime { get; set; }
        /// <summary> The user who created the record. </summary>
        public string CreatedBy { get; set; }
        /// <summary> Reference to an object-instance of a type - like entity. </summary>
        public AtlasObjectId End1 { get; set; }
        /// <summary> Reference to an object-instance of a type - like entity. </summary>
        public AtlasObjectId End2 { get; set; }
        /// <summary> The GUID of the relationship. </summary>
        public string Guid { get; set; }
        /// <summary> The home ID of the relationship. </summary>
        public string HomeId { get; set; }
        /// <summary> The label of the relationship. </summary>
        public string Label { get; set; }
        /// <summary> Used to record the provenance of an instance of an entity or relationship. </summary>
        public int? ProvenanceType { get; set; }
        /// <summary> The enum of relationship status. </summary>
        public StatusAtlasRelationship? Status { get; set; }
        /// <summary> The update time of the record. </summary>
        public long? UpdateTime { get; set; }
        /// <summary> The user who updated the record. </summary>
        public string UpdatedBy { get; set; }
        /// <summary> The version of the relationship. </summary>
        public long? Version { get; set; }
    }
}
