// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The header of the related term. </summary>
    public partial class AtlasRelatedTermHeader
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasRelatedTermHeader"/>. </summary>
        public AtlasRelatedTermHeader()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AtlasRelatedTermHeader"/>. </summary>
        /// <param name="description"> The description of the related term. </param>
        /// <param name="displayText"> The display text. </param>
        /// <param name="expression"> The expression of the term. </param>
        /// <param name="relationGuid"> The GUID of the relationship. </param>
        /// <param name="status"> The status of term relationship. </param>
        /// <param name="steward"> The steward of the term. </param>
        /// <param name="termGuid"> The GUID of the term. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasRelatedTermHeader(string description, string displayText, string expression, string relationGuid, AtlasTermRelationshipStatus? status, string steward, string termGuid, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Description = description;
            DisplayText = displayText;
            Expression = expression;
            RelationGuid = relationGuid;
            Status = status;
            Steward = steward;
            TermGuid = termGuid;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The description of the related term. </summary>
        public string Description { get; set; }
        /// <summary> The display text. </summary>
        public string DisplayText { get; set; }
        /// <summary> The expression of the term. </summary>
        public string Expression { get; set; }
        /// <summary> The GUID of the relationship. </summary>
        public string RelationGuid { get; set; }
        /// <summary> The status of term relationship. </summary>
        public AtlasTermRelationshipStatus? Status { get; set; }
        /// <summary> The steward of the term. </summary>
        public string Steward { get; set; }
        /// <summary> The GUID of the term. </summary>
        public string TermGuid { get; set; }
    }
}
