// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary>
    /// Reference to an object-instance of AtlasEntity type used in relationship
    /// attribute values
    /// </summary>
    public partial class AtlasRelatedObjectId
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasRelatedObjectId"/>. </summary>
        public AtlasRelatedObjectId()
        {
            UniqueAttributes = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasRelatedObjectId"/>. </summary>
        /// <param name="guid"> The GUID of the object. </param>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="uniqueAttributes"> The unique attributes of the object. </param>
        /// <param name="displayText"> The display text. </param>
        /// <param name="entityStatus">
        /// Status of the entity - can be active or deleted. Deleted entities are not
        /// removed.
        /// </param>
        /// <param name="relationshipType"> Relationship type. </param>
        /// <param name="relationshipAttributes">
        /// Captures details of struct contents. Not instantiated directly, used only via
        /// AtlasEntity, AtlasClassification.
        /// </param>
        /// <param name="relationshipGuid"> The GUID of the relationship. </param>
        /// <param name="relationshipStatus"> The enum of relationship status. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasRelatedObjectId(string guid, string typeName, IDictionary<string, BinaryData> uniqueAttributes, string displayText, EntityStatus? entityStatus, string relationshipType, AtlasStruct relationshipAttributes, Guid? relationshipGuid, StatusAtlasRelationship? relationshipStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Guid = guid;
            TypeName = typeName;
            UniqueAttributes = uniqueAttributes;
            DisplayText = displayText;
            EntityStatus = entityStatus;
            RelationshipType = relationshipType;
            RelationshipAttributes = relationshipAttributes;
            RelationshipGuid = relationshipGuid;
            RelationshipStatus = relationshipStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The GUID of the object. </summary>
        public string Guid { get; set; }
        /// <summary> The name of the type. </summary>
        public string TypeName { get; set; }
        /// <summary>
        /// The unique attributes of the object.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> UniqueAttributes { get; }
        /// <summary> The display text. </summary>
        public string DisplayText { get; set; }
        /// <summary>
        /// Status of the entity - can be active or deleted. Deleted entities are not
        /// removed.
        /// </summary>
        public EntityStatus? EntityStatus { get; set; }
        /// <summary> Relationship type. </summary>
        public string RelationshipType { get; set; }
        /// <summary>
        /// Captures details of struct contents. Not instantiated directly, used only via
        /// AtlasEntity, AtlasClassification.
        /// </summary>
        public AtlasStruct RelationshipAttributes { get; set; }
        /// <summary> The GUID of the relationship. </summary>
        public Guid? RelationshipGuid { get; set; }
        /// <summary> The enum of relationship status. </summary>
        public StatusAtlasRelationship? RelationshipStatus { get; set; }
    }
}
