// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Analytics.Purview.DataMap
{
    public partial class AtlasRelatedObjectId : IUtf8JsonSerializable, IJsonModel<AtlasRelatedObjectId>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AtlasRelatedObjectId>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AtlasRelatedObjectId>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasRelatedObjectId>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AtlasRelatedObjectId)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Guid))
            {
                writer.WritePropertyName("guid"u8);
                writer.WriteStringValue(Guid);
            }
            if (Optional.IsDefined(TypeName))
            {
                writer.WritePropertyName("typeName"u8);
                writer.WriteStringValue(TypeName);
            }
            if (Optional.IsCollectionDefined(UniqueAttributes))
            {
                writer.WritePropertyName("uniqueAttributes"u8);
                writer.WriteStartObject();
                foreach (var item in UniqueAttributes)
                {
                    writer.WritePropertyName(item.Key);
                    if (item.Value == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(DisplayText))
            {
                writer.WritePropertyName("displayText"u8);
                writer.WriteStringValue(DisplayText);
            }
            if (Optional.IsDefined(EntityStatus))
            {
                writer.WritePropertyName("entityStatus"u8);
                writer.WriteStringValue(EntityStatus.Value.ToString());
            }
            if (Optional.IsDefined(RelationshipType))
            {
                writer.WritePropertyName("relationshipType"u8);
                writer.WriteStringValue(RelationshipType);
            }
            if (Optional.IsDefined(RelationshipAttributes))
            {
                writer.WritePropertyName("relationshipAttributes"u8);
                writer.WriteObjectValue(RelationshipAttributes, options);
            }
            if (Optional.IsDefined(RelationshipGuid))
            {
                writer.WritePropertyName("relationshipGuid"u8);
                writer.WriteStringValue(RelationshipGuid.Value);
            }
            if (Optional.IsDefined(RelationshipStatus))
            {
                writer.WritePropertyName("relationshipStatus"u8);
                writer.WriteStringValue(RelationshipStatus.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AtlasRelatedObjectId IJsonModel<AtlasRelatedObjectId>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasRelatedObjectId>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AtlasRelatedObjectId)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAtlasRelatedObjectId(document.RootElement, options);
        }

        internal static AtlasRelatedObjectId DeserializeAtlasRelatedObjectId(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string guid = default;
            string typeName = default;
            IDictionary<string, BinaryData> uniqueAttributes = default;
            string displayText = default;
            EntityStatus? entityStatus = default;
            string relationshipType = default;
            AtlasStruct relationshipAttributes = default;
            Guid? relationshipGuid = default;
            StatusAtlasRelationship? relationshipStatus = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("guid"u8))
                {
                    guid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("typeName"u8))
                {
                    typeName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("uniqueAttributes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, BinaryData> dictionary = new Dictionary<string, BinaryData>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.Value.ValueKind == JsonValueKind.Null)
                        {
                            dictionary.Add(property0.Name, null);
                        }
                        else
                        {
                            dictionary.Add(property0.Name, BinaryData.FromString(property0.Value.GetRawText()));
                        }
                    }
                    uniqueAttributes = dictionary;
                    continue;
                }
                if (property.NameEquals("displayText"u8))
                {
                    displayText = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("entityStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    entityStatus = new EntityStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("relationshipType"u8))
                {
                    relationshipType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("relationshipAttributes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    relationshipAttributes = AtlasStruct.DeserializeAtlasStruct(property.Value, options);
                    continue;
                }
                if (property.NameEquals("relationshipGuid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    relationshipGuid = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("relationshipStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    relationshipStatus = new StatusAtlasRelationship(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AtlasRelatedObjectId(
                guid,
                typeName,
                uniqueAttributes ?? new ChangeTrackingDictionary<string, BinaryData>(),
                displayText,
                entityStatus,
                relationshipType,
                relationshipAttributes,
                relationshipGuid,
                relationshipStatus,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AtlasRelatedObjectId>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasRelatedObjectId>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AtlasRelatedObjectId)} does not support writing '{options.Format}' format.");
            }
        }

        AtlasRelatedObjectId IPersistableModel<AtlasRelatedObjectId>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasRelatedObjectId>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAtlasRelatedObjectId(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AtlasRelatedObjectId)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AtlasRelatedObjectId>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AtlasRelatedObjectId FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAtlasRelatedObjectId(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
