// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The header of the related category. </summary>
    public partial class AtlasRelatedCategoryHeader
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasRelatedCategoryHeader"/>. </summary>
        public AtlasRelatedCategoryHeader()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AtlasRelatedCategoryHeader"/>. </summary>
        /// <param name="categoryGuid"> The GUID of the category. </param>
        /// <param name="description"> The description of the category header. </param>
        /// <param name="displayText"> The display text. </param>
        /// <param name="parentCategoryGuid"> The GUID of the parent category. </param>
        /// <param name="relationGuid"> The GUID of the relationship. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasRelatedCategoryHeader(string categoryGuid, string description, string displayText, string parentCategoryGuid, string relationGuid, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CategoryGuid = categoryGuid;
            Description = description;
            DisplayText = displayText;
            ParentCategoryGuid = parentCategoryGuid;
            RelationGuid = relationGuid;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The GUID of the category. </summary>
        public string CategoryGuid { get; set; }
        /// <summary> The description of the category header. </summary>
        public string Description { get; set; }
        /// <summary> The display text. </summary>
        public string DisplayText { get; set; }
        /// <summary> The GUID of the parent category. </summary>
        public string ParentCategoryGuid { get; set; }
        /// <summary> The GUID of the relationship. </summary>
        public string RelationGuid { get; set; }
    }
}
