// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The number format. </summary>
    public partial class AtlasNumberFormat
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasNumberFormat"/>. </summary>
        public AtlasNumberFormat()
        {
            AvailableLocales = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasNumberFormat"/>. </summary>
        /// <param name="availableLocales"> The number format. </param>
        /// <param name="currency"> The currency. </param>
        /// <param name="currencyInstance"> The number format. </param>
        /// <param name="groupingUsed"> Determines if grouping is used. </param>
        /// <param name="instance"> The number format. </param>
        /// <param name="integerInstance"> The number format. </param>
        /// <param name="maximumFractionDigits"> The maximum of fraction digits. </param>
        /// <param name="maximumIntegerDigits"> The maximum of integer digits. </param>
        /// <param name="minimumFractionDigits"> The minimum of fraction digits. </param>
        /// <param name="minimumIntegerDigits"> The minimum of integer digits. </param>
        /// <param name="numberInstance"> The number format. </param>
        /// <param name="parseIntegerOnly"> Determines if only integer is parsed. </param>
        /// <param name="percentInstance"> The number format. </param>
        /// <param name="roundingMode"> The enum of rounding mode. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasNumberFormat(IList<string> availableLocales, string currency, AtlasNumberFormat currencyInstance, bool? groupingUsed, AtlasNumberFormat instance, AtlasNumberFormat integerInstance, int? maximumFractionDigits, int? maximumIntegerDigits, int? minimumFractionDigits, int? minimumIntegerDigits, AtlasNumberFormat numberInstance, bool? parseIntegerOnly, AtlasNumberFormat percentInstance, RoundingMode? roundingMode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AvailableLocales = availableLocales;
            Currency = currency;
            CurrencyInstance = currencyInstance;
            GroupingUsed = groupingUsed;
            Instance = instance;
            IntegerInstance = integerInstance;
            MaximumFractionDigits = maximumFractionDigits;
            MaximumIntegerDigits = maximumIntegerDigits;
            MinimumFractionDigits = minimumFractionDigits;
            MinimumIntegerDigits = minimumIntegerDigits;
            NumberInstance = numberInstance;
            ParseIntegerOnly = parseIntegerOnly;
            PercentInstance = percentInstance;
            RoundingMode = roundingMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The number format. </summary>
        public IList<string> AvailableLocales { get; }
        /// <summary> The currency. </summary>
        public string Currency { get; set; }
        /// <summary> The number format. </summary>
        public AtlasNumberFormat CurrencyInstance { get; set; }
        /// <summary> Determines if grouping is used. </summary>
        public bool? GroupingUsed { get; set; }
        /// <summary> The number format. </summary>
        public AtlasNumberFormat Instance { get; set; }
        /// <summary> The number format. </summary>
        public AtlasNumberFormat IntegerInstance { get; set; }
        /// <summary> The maximum of fraction digits. </summary>
        public int? MaximumFractionDigits { get; set; }
        /// <summary> The maximum of integer digits. </summary>
        public int? MaximumIntegerDigits { get; set; }
        /// <summary> The minimum of fraction digits. </summary>
        public int? MinimumFractionDigits { get; set; }
        /// <summary> The minimum of integer digits. </summary>
        public int? MinimumIntegerDigits { get; set; }
        /// <summary> The number format. </summary>
        public AtlasNumberFormat NumberInstance { get; set; }
        /// <summary> Determines if only integer is parsed. </summary>
        public bool? ParseIntegerOnly { get; set; }
        /// <summary> The number format. </summary>
        public AtlasNumberFormat PercentInstance { get; set; }
        /// <summary> The enum of rounding mode. </summary>
        public RoundingMode? RoundingMode { get; set; }
    }
}
