// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Analytics.Purview.DataMap
{
    public partial class AtlasNumberFormat : IUtf8JsonSerializable, IJsonModel<AtlasNumberFormat>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AtlasNumberFormat>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AtlasNumberFormat>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasNumberFormat>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AtlasNumberFormat)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(AvailableLocales))
            {
                writer.WritePropertyName("availableLocales"u8);
                writer.WriteStartArray();
                foreach (var item in AvailableLocales)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Currency))
            {
                writer.WritePropertyName("currency"u8);
                writer.WriteStringValue(Currency);
            }
            if (Optional.IsDefined(CurrencyInstance))
            {
                writer.WritePropertyName("currencyInstance"u8);
                writer.WriteObjectValue(CurrencyInstance, options);
            }
            if (Optional.IsDefined(GroupingUsed))
            {
                writer.WritePropertyName("groupingUsed"u8);
                writer.WriteBooleanValue(GroupingUsed.Value);
            }
            if (Optional.IsDefined(Instance))
            {
                writer.WritePropertyName("instance"u8);
                writer.WriteObjectValue(Instance, options);
            }
            if (Optional.IsDefined(IntegerInstance))
            {
                writer.WritePropertyName("integerInstance"u8);
                writer.WriteObjectValue(IntegerInstance, options);
            }
            if (Optional.IsDefined(MaximumFractionDigits))
            {
                writer.WritePropertyName("maximumFractionDigits"u8);
                writer.WriteNumberValue(MaximumFractionDigits.Value);
            }
            if (Optional.IsDefined(MaximumIntegerDigits))
            {
                writer.WritePropertyName("maximumIntegerDigits"u8);
                writer.WriteNumberValue(MaximumIntegerDigits.Value);
            }
            if (Optional.IsDefined(MinimumFractionDigits))
            {
                writer.WritePropertyName("minimumFractionDigits"u8);
                writer.WriteNumberValue(MinimumFractionDigits.Value);
            }
            if (Optional.IsDefined(MinimumIntegerDigits))
            {
                writer.WritePropertyName("minimumIntegerDigits"u8);
                writer.WriteNumberValue(MinimumIntegerDigits.Value);
            }
            if (Optional.IsDefined(NumberInstance))
            {
                writer.WritePropertyName("numberInstance"u8);
                writer.WriteObjectValue(NumberInstance, options);
            }
            if (Optional.IsDefined(ParseIntegerOnly))
            {
                writer.WritePropertyName("parseIntegerOnly"u8);
                writer.WriteBooleanValue(ParseIntegerOnly.Value);
            }
            if (Optional.IsDefined(PercentInstance))
            {
                writer.WritePropertyName("percentInstance"u8);
                writer.WriteObjectValue(PercentInstance, options);
            }
            if (Optional.IsDefined(RoundingMode))
            {
                writer.WritePropertyName("roundingMode"u8);
                writer.WriteStringValue(RoundingMode.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AtlasNumberFormat IJsonModel<AtlasNumberFormat>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasNumberFormat>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AtlasNumberFormat)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAtlasNumberFormat(document.RootElement, options);
        }

        internal static AtlasNumberFormat DeserializeAtlasNumberFormat(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<string> availableLocales = default;
            string currency = default;
            AtlasNumberFormat currencyInstance = default;
            bool? groupingUsed = default;
            AtlasNumberFormat instance = default;
            AtlasNumberFormat integerInstance = default;
            int? maximumFractionDigits = default;
            int? maximumIntegerDigits = default;
            int? minimumFractionDigits = default;
            int? minimumIntegerDigits = default;
            AtlasNumberFormat numberInstance = default;
            bool? parseIntegerOnly = default;
            AtlasNumberFormat percentInstance = default;
            RoundingMode? roundingMode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("availableLocales"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    availableLocales = array;
                    continue;
                }
                if (property.NameEquals("currency"u8))
                {
                    currency = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("currencyInstance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    currencyInstance = DeserializeAtlasNumberFormat(property.Value, options);
                    continue;
                }
                if (property.NameEquals("groupingUsed"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    groupingUsed = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("instance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    instance = DeserializeAtlasNumberFormat(property.Value, options);
                    continue;
                }
                if (property.NameEquals("integerInstance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    integerInstance = DeserializeAtlasNumberFormat(property.Value, options);
                    continue;
                }
                if (property.NameEquals("maximumFractionDigits"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maximumFractionDigits = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maximumIntegerDigits"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maximumIntegerDigits = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minimumFractionDigits"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minimumFractionDigits = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minimumIntegerDigits"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minimumIntegerDigits = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("numberInstance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    numberInstance = DeserializeAtlasNumberFormat(property.Value, options);
                    continue;
                }
                if (property.NameEquals("parseIntegerOnly"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    parseIntegerOnly = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("percentInstance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    percentInstance = DeserializeAtlasNumberFormat(property.Value, options);
                    continue;
                }
                if (property.NameEquals("roundingMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    roundingMode = new RoundingMode(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AtlasNumberFormat(
                availableLocales ?? new ChangeTrackingList<string>(),
                currency,
                currencyInstance,
                groupingUsed,
                instance,
                integerInstance,
                maximumFractionDigits,
                maximumIntegerDigits,
                minimumFractionDigits,
                minimumIntegerDigits,
                numberInstance,
                parseIntegerOnly,
                percentInstance,
                roundingMode,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AtlasNumberFormat>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasNumberFormat>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AtlasNumberFormat)} does not support writing '{options.Format}' format.");
            }
        }

        AtlasNumberFormat IPersistableModel<AtlasNumberFormat>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasNumberFormat>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAtlasNumberFormat(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AtlasNumberFormat)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AtlasNumberFormat>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AtlasNumberFormat FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAtlasNumberFormat(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
