// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Analytics.Purview.DataMap
{
    public partial class AtlasGlossaryTerm : IUtf8JsonSerializable, IJsonModel<AtlasGlossaryTerm>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AtlasGlossaryTerm>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AtlasGlossaryTerm>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasGlossaryTerm>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AtlasGlossaryTerm)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Guid))
            {
                writer.WritePropertyName("guid"u8);
                writer.WriteStringValue(Guid);
            }
            if (Optional.IsCollectionDefined(Classifications))
            {
                writer.WritePropertyName("classifications"u8);
                writer.WriteStartArray();
                foreach (var item in Classifications)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(LongDescription))
            {
                writer.WritePropertyName("longDescription"u8);
                writer.WriteStringValue(LongDescription);
            }
            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(QualifiedName))
            {
                writer.WritePropertyName("qualifiedName"u8);
                writer.WriteStringValue(QualifiedName);
            }
            if (Optional.IsDefined(ShortDescription))
            {
                writer.WritePropertyName("shortDescription"u8);
                writer.WriteStringValue(ShortDescription);
            }
            if (Optional.IsDefined(LastModifiedTS))
            {
                writer.WritePropertyName("lastModifiedTS"u8);
                writer.WriteStringValue(LastModifiedTS);
            }
            if (Optional.IsDefined(CreateTime))
            {
                writer.WritePropertyName("createTime"u8);
                writer.WriteNumberValue(CreateTime.Value);
            }
            if (Optional.IsDefined(CreatedBy))
            {
                writer.WritePropertyName("createdBy"u8);
                writer.WriteStringValue(CreatedBy);
            }
            if (Optional.IsDefined(UpdateTime))
            {
                writer.WritePropertyName("updateTime"u8);
                writer.WriteNumberValue(UpdateTime.Value);
            }
            if (Optional.IsDefined(UpdatedBy))
            {
                writer.WritePropertyName("updatedBy"u8);
                writer.WriteStringValue(UpdatedBy);
            }
            if (Optional.IsDefined(Abbreviation))
            {
                writer.WritePropertyName("abbreviation"u8);
                writer.WriteStringValue(Abbreviation);
            }
            if (Optional.IsCollectionDefined(TemplateName))
            {
                writer.WritePropertyName("templateName"u8);
                writer.WriteStartArray();
                foreach (var item in TemplateName)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item);
#else
                    using (JsonDocument document = JsonDocument.Parse(item))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Anchor))
            {
                writer.WritePropertyName("anchor"u8);
                writer.WriteObjectValue(Anchor, options);
            }
            if (Optional.IsCollectionDefined(Antonyms))
            {
                writer.WritePropertyName("antonyms"u8);
                writer.WriteStartArray();
                foreach (var item in Antonyms)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (Optional.IsDefined(NickName))
            {
                writer.WritePropertyName("nickName"u8);
                writer.WriteStringValue(NickName);
            }
            if (Optional.IsCollectionDefined(HierarchyInfo))
            {
                writer.WritePropertyName("hierarchyInfo"u8);
                writer.WriteStartArray();
                foreach (var item in HierarchyInfo)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Resources))
            {
                writer.WritePropertyName("resources"u8);
                writer.WriteStartArray();
                foreach (var item in Resources)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Contacts))
            {
                writer.WritePropertyName("contacts"u8);
                writer.WriteStartObject();
                foreach (var item in Contacts)
                {
                    writer.WritePropertyName(item.Key);
                    if (item.Value == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStartArray();
                    foreach (var item0 in item.Value)
                    {
                        writer.WriteObjectValue(item0, options);
                    }
                    writer.WriteEndArray();
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(Attributes))
            {
                writer.WritePropertyName("attributes"u8);
                writer.WriteStartObject();
                foreach (var item in Attributes)
                {
                    writer.WritePropertyName(item.Key);
                    if (item.Value == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStartObject();
                    foreach (var item0 in item.Value)
                    {
                        writer.WritePropertyName(item0.Key);
                        if (item0.Value == null)
                        {
                            writer.WriteNullValue();
                            continue;
                        }
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item0.Value);
#else
                        using (JsonDocument document = JsonDocument.Parse(item0.Value))
                        {
                            JsonSerializer.Serialize(writer, document.RootElement);
                        }
#endif
                    }
                    writer.WriteEndObject();
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(AssignedEntities))
            {
                writer.WritePropertyName("assignedEntities"u8);
                writer.WriteStartArray();
                foreach (var item in AssignedEntities)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Categories))
            {
                writer.WritePropertyName("categories"u8);
                writer.WriteStartArray();
                foreach (var item in Categories)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Classifies))
            {
                writer.WritePropertyName("classifies"u8);
                writer.WriteStartArray();
                foreach (var item in Classifies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Examples))
            {
                writer.WritePropertyName("examples"u8);
                writer.WriteStartArray();
                foreach (var item in Examples)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IsA))
            {
                writer.WritePropertyName("isA"u8);
                writer.WriteStartArray();
                foreach (var item in IsA)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PreferredTerms))
            {
                writer.WritePropertyName("preferredTerms"u8);
                writer.WriteStartArray();
                foreach (var item in PreferredTerms)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PreferredToTerms))
            {
                writer.WritePropertyName("preferredToTerms"u8);
                writer.WriteStartArray();
                foreach (var item in PreferredToTerms)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ReplacedBy))
            {
                writer.WritePropertyName("replacedBy"u8);
                writer.WriteStartArray();
                foreach (var item in ReplacedBy)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ReplacementTerms))
            {
                writer.WritePropertyName("replacementTerms"u8);
                writer.WriteStartArray();
                foreach (var item in ReplacementTerms)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SeeAlso))
            {
                writer.WritePropertyName("seeAlso"u8);
                writer.WriteStartArray();
                foreach (var item in SeeAlso)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Synonyms))
            {
                writer.WritePropertyName("synonyms"u8);
                writer.WriteStartArray();
                foreach (var item in Synonyms)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TranslatedTerms))
            {
                writer.WritePropertyName("translatedTerms"u8);
                writer.WriteStartArray();
                foreach (var item in TranslatedTerms)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TranslationTerms))
            {
                writer.WritePropertyName("translationTerms"u8);
                writer.WriteStartArray();
                foreach (var item in TranslationTerms)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Usage))
            {
                writer.WritePropertyName("usage"u8);
                writer.WriteStringValue(Usage);
            }
            if (Optional.IsCollectionDefined(ValidValues))
            {
                writer.WritePropertyName("validValues"u8);
                writer.WriteStartArray();
                foreach (var item in ValidValues)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ValidValuesFor))
            {
                writer.WritePropertyName("validValuesFor"u8);
                writer.WriteStartArray();
                foreach (var item in ValidValuesFor)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AtlasGlossaryTerm IJsonModel<AtlasGlossaryTerm>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasGlossaryTerm>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AtlasGlossaryTerm)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAtlasGlossaryTerm(document.RootElement, options);
        }

        internal static AtlasGlossaryTerm DeserializeAtlasGlossaryTerm(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string guid = default;
            IList<AtlasClassification> classifications = default;
            string longDescription = default;
            string name = default;
            string qualifiedName = default;
            string shortDescription = default;
            string lastModifiedTS = default;
            long? createTime = default;
            string createdBy = default;
            long? updateTime = default;
            string updatedBy = default;
            string abbreviation = default;
            IList<BinaryData> templateName = default;
            AtlasGlossaryHeader anchor = default;
            IList<AtlasRelatedTermHeader> antonyms = default;
            TermStatus? status = default;
            string nickName = default;
            IList<PurviewObjectId> hierarchyInfo = default;
            IList<ResourceLink> resources = default;
            IDictionary<string, IList<ContactInfo>> contacts = default;
            IDictionary<string, IDictionary<string, BinaryData>> attributes = default;
            IList<AtlasRelatedObjectId> assignedEntities = default;
            IList<AtlasTermCategorizationHeader> categories = default;
            IList<AtlasRelatedTermHeader> classifies = default;
            IList<string> examples = default;
            IList<AtlasRelatedTermHeader> isA = default;
            IList<AtlasRelatedTermHeader> preferredTerms = default;
            IList<AtlasRelatedTermHeader> preferredToTerms = default;
            IList<AtlasRelatedTermHeader> replacedBy = default;
            IList<AtlasRelatedTermHeader> replacementTerms = default;
            IList<AtlasRelatedTermHeader> seeAlso = default;
            IList<AtlasRelatedTermHeader> synonyms = default;
            IList<AtlasRelatedTermHeader> translatedTerms = default;
            IList<AtlasRelatedTermHeader> translationTerms = default;
            string usage = default;
            IList<AtlasRelatedTermHeader> validValues = default;
            IList<AtlasRelatedTermHeader> validValuesFor = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("guid"u8))
                {
                    guid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("classifications"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasClassification> array = new List<AtlasClassification>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasClassification.DeserializeAtlasClassification(item, options));
                    }
                    classifications = array;
                    continue;
                }
                if (property.NameEquals("longDescription"u8))
                {
                    longDescription = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("qualifiedName"u8))
                {
                    qualifiedName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("shortDescription"u8))
                {
                    shortDescription = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastModifiedTS"u8))
                {
                    lastModifiedTS = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("createTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    createTime = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("createdBy"u8))
                {
                    createdBy = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("updateTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    updateTime = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("updatedBy"u8))
                {
                    updatedBy = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("abbreviation"u8))
                {
                    abbreviation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("templateName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BinaryData> array = new List<BinaryData>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            array.Add(BinaryData.FromString(item.GetRawText()));
                        }
                    }
                    templateName = array;
                    continue;
                }
                if (property.NameEquals("anchor"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    anchor = AtlasGlossaryHeader.DeserializeAtlasGlossaryHeader(property.Value, options);
                    continue;
                }
                if (property.NameEquals("antonyms"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    antonyms = array;
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    status = new TermStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("nickName"u8))
                {
                    nickName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("hierarchyInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<PurviewObjectId> array = new List<PurviewObjectId>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(PurviewObjectId.DeserializePurviewObjectId(item, options));
                    }
                    hierarchyInfo = array;
                    continue;
                }
                if (property.NameEquals("resources"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceLink> array = new List<ResourceLink>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResourceLink.DeserializeResourceLink(item, options));
                    }
                    resources = array;
                    continue;
                }
                if (property.NameEquals("contacts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, IList<ContactInfo>> dictionary = new Dictionary<string, IList<ContactInfo>>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.Value.ValueKind == JsonValueKind.Null)
                        {
                            dictionary.Add(property0.Name, null);
                        }
                        else
                        {
                            List<ContactInfo> array = new List<ContactInfo>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ContactInfo.DeserializeContactInfo(item, options));
                            }
                            dictionary.Add(property0.Name, array);
                        }
                    }
                    contacts = dictionary;
                    continue;
                }
                if (property.NameEquals("attributes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, IDictionary<string, BinaryData>> dictionary = new Dictionary<string, IDictionary<string, BinaryData>>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.Value.ValueKind == JsonValueKind.Null)
                        {
                            dictionary.Add(property0.Name, null);
                        }
                        else
                        {
                            Dictionary<string, BinaryData> dictionary0 = new Dictionary<string, BinaryData>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.Value.ValueKind == JsonValueKind.Null)
                                {
                                    dictionary0.Add(property1.Name, null);
                                }
                                else
                                {
                                    dictionary0.Add(property1.Name, BinaryData.FromString(property1.Value.GetRawText()));
                                }
                            }
                            dictionary.Add(property0.Name, dictionary0);
                        }
                    }
                    attributes = dictionary;
                    continue;
                }
                if (property.NameEquals("assignedEntities"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedObjectId> array = new List<AtlasRelatedObjectId>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedObjectId.DeserializeAtlasRelatedObjectId(item, options));
                    }
                    assignedEntities = array;
                    continue;
                }
                if (property.NameEquals("categories"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasTermCategorizationHeader> array = new List<AtlasTermCategorizationHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasTermCategorizationHeader.DeserializeAtlasTermCategorizationHeader(item, options));
                    }
                    categories = array;
                    continue;
                }
                if (property.NameEquals("classifies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    classifies = array;
                    continue;
                }
                if (property.NameEquals("examples"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    examples = array;
                    continue;
                }
                if (property.NameEquals("isA"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    isA = array;
                    continue;
                }
                if (property.NameEquals("preferredTerms"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    preferredTerms = array;
                    continue;
                }
                if (property.NameEquals("preferredToTerms"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    preferredToTerms = array;
                    continue;
                }
                if (property.NameEquals("replacedBy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    replacedBy = array;
                    continue;
                }
                if (property.NameEquals("replacementTerms"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    replacementTerms = array;
                    continue;
                }
                if (property.NameEquals("seeAlso"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    seeAlso = array;
                    continue;
                }
                if (property.NameEquals("synonyms"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    synonyms = array;
                    continue;
                }
                if (property.NameEquals("translatedTerms"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    translatedTerms = array;
                    continue;
                }
                if (property.NameEquals("translationTerms"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    translationTerms = array;
                    continue;
                }
                if (property.NameEquals("usage"u8))
                {
                    usage = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("validValues"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    validValues = array;
                    continue;
                }
                if (property.NameEquals("validValuesFor"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AtlasRelatedTermHeader> array = new List<AtlasRelatedTermHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AtlasRelatedTermHeader.DeserializeAtlasRelatedTermHeader(item, options));
                    }
                    validValuesFor = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AtlasGlossaryTerm(
                guid,
                classifications ?? new ChangeTrackingList<AtlasClassification>(),
                longDescription,
                name,
                qualifiedName,
                shortDescription,
                lastModifiedTS,
                createTime,
                createdBy,
                updateTime,
                updatedBy,
                abbreviation,
                templateName ?? new ChangeTrackingList<BinaryData>(),
                anchor,
                antonyms ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                status,
                nickName,
                hierarchyInfo ?? new ChangeTrackingList<PurviewObjectId>(),
                resources ?? new ChangeTrackingList<ResourceLink>(),
                contacts ?? new ChangeTrackingDictionary<string, IList<ContactInfo>>(),
                attributes ?? new ChangeTrackingDictionary<string, IDictionary<string, BinaryData>>(),
                assignedEntities ?? new ChangeTrackingList<AtlasRelatedObjectId>(),
                categories ?? new ChangeTrackingList<AtlasTermCategorizationHeader>(),
                classifies ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                examples ?? new ChangeTrackingList<string>(),
                isA ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                preferredTerms ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                preferredToTerms ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                replacedBy ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                replacementTerms ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                seeAlso ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                synonyms ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                translatedTerms ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                translationTerms ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                usage,
                validValues ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                validValuesFor ?? new ChangeTrackingList<AtlasRelatedTermHeader>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AtlasGlossaryTerm>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasGlossaryTerm>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AtlasGlossaryTerm)} does not support writing '{options.Format}' format.");
            }
        }

        AtlasGlossaryTerm IPersistableModel<AtlasGlossaryTerm>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AtlasGlossaryTerm>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAtlasGlossaryTerm(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AtlasGlossaryTerm)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AtlasGlossaryTerm>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AtlasGlossaryTerm FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAtlasGlossaryTerm(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
