// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The glossary header with basic information. </summary>
    public partial class AtlasGlossaryHeader
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasGlossaryHeader"/>. </summary>
        public AtlasGlossaryHeader()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AtlasGlossaryHeader"/>. </summary>
        /// <param name="displayText"> The display text. </param>
        /// <param name="glossaryGuid"> The GUID of the glossary. </param>
        /// <param name="relationGuid"> The GUID of the relationship. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasGlossaryHeader(string displayText, string glossaryGuid, string relationGuid, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisplayText = displayText;
            GlossaryGuid = glossaryGuid;
            RelationGuid = relationGuid;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The display text. </summary>
        public string DisplayText { get; set; }
        /// <summary> The GUID of the glossary. </summary>
        public string GlossaryGuid { get; set; }
        /// <summary> The GUID of the relationship. </summary>
        public string RelationGuid { get; set; }
    }
}
