// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The glossary category. </summary>
    public partial class AtlasGlossaryCategory
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasGlossaryCategory"/>. </summary>
        public AtlasGlossaryCategory()
        {
            Classifications = new ChangeTrackingList<AtlasClassification>();
            ChildrenCategories = new ChangeTrackingList<AtlasRelatedCategoryHeader>();
            Terms = new ChangeTrackingList<AtlasRelatedTermHeader>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasGlossaryCategory"/>. </summary>
        /// <param name="guid"> The GUID of the object. </param>
        /// <param name="classifications"> An array of classifications. </param>
        /// <param name="longDescription"> The long version description. </param>
        /// <param name="name"> The name of the glossary object. </param>
        /// <param name="qualifiedName"> The qualified name of the glossary object. </param>
        /// <param name="shortDescription"> The short version of description. </param>
        /// <param name="lastModifiedTS"> ETag for concurrency control. </param>
        /// <param name="createTime"> The created time of the record. </param>
        /// <param name="createdBy"> The user who created the record. </param>
        /// <param name="updateTime"> The update time of the record. </param>
        /// <param name="updatedBy"> The user who updated the record. </param>
        /// <param name="anchor"> The glossary header with basic information. </param>
        /// <param name="childrenCategories"> An array of children categories. </param>
        /// <param name="parentCategory"> The header of the related category. </param>
        /// <param name="terms"> An array of related term headers. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasGlossaryCategory(string guid, IList<AtlasClassification> classifications, string longDescription, string name, string qualifiedName, string shortDescription, string lastModifiedTS, long? createTime, string createdBy, long? updateTime, string updatedBy, AtlasGlossaryHeader anchor, IList<AtlasRelatedCategoryHeader> childrenCategories, AtlasRelatedCategoryHeader parentCategory, IList<AtlasRelatedTermHeader> terms, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Guid = guid;
            Classifications = classifications;
            LongDescription = longDescription;
            Name = name;
            QualifiedName = qualifiedName;
            ShortDescription = shortDescription;
            LastModifiedTS = lastModifiedTS;
            CreateTime = createTime;
            CreatedBy = createdBy;
            UpdateTime = updateTime;
            UpdatedBy = updatedBy;
            Anchor = anchor;
            ChildrenCategories = childrenCategories;
            ParentCategory = parentCategory;
            Terms = terms;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The GUID of the object. </summary>
        public string Guid { get; set; }
        /// <summary> An array of classifications. </summary>
        public IList<AtlasClassification> Classifications { get; }
        /// <summary> The long version description. </summary>
        public string LongDescription { get; set; }
        /// <summary> The name of the glossary object. </summary>
        public string Name { get; set; }
        /// <summary> The qualified name of the glossary object. </summary>
        public string QualifiedName { get; set; }
        /// <summary> The short version of description. </summary>
        public string ShortDescription { get; set; }
        /// <summary> ETag for concurrency control. </summary>
        public string LastModifiedTS { get; set; }
        /// <summary> The created time of the record. </summary>
        public long? CreateTime { get; set; }
        /// <summary> The user who created the record. </summary>
        public string CreatedBy { get; set; }
        /// <summary> The update time of the record. </summary>
        public long? UpdateTime { get; set; }
        /// <summary> The user who updated the record. </summary>
        public string UpdatedBy { get; set; }
        /// <summary> The glossary header with basic information. </summary>
        public AtlasGlossaryHeader Anchor { get; set; }
        /// <summary> An array of children categories. </summary>
        public IList<AtlasRelatedCategoryHeader> ChildrenCategories { get; }
        /// <summary> The header of the related category. </summary>
        public AtlasRelatedCategoryHeader ParentCategory { get; set; }
        /// <summary> An array of related term headers. </summary>
        public IList<AtlasRelatedTermHeader> Terms { get; }
    }
}
