// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> class that captures details of an enum-element. </summary>
    public partial class AtlasEnumElementDef
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasEnumElementDef"/>. </summary>
        public AtlasEnumElementDef()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AtlasEnumElementDef"/>. </summary>
        /// <param name="description"> The description of the enum element definition. </param>
        /// <param name="ordinal"> The ordinal of the enum element definition. </param>
        /// <param name="value"> The value of the enum element definition. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasEnumElementDef(string description, int? ordinal, string value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Description = description;
            Ordinal = ordinal;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The description of the enum element definition. </summary>
        public string Description { get; set; }
        /// <summary> The ordinal of the enum element definition. </summary>
        public int? Ordinal { get; set; }
        /// <summary> The value of the enum element definition. </summary>
        public string Value { get; set; }
    }
}
