// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> An instance of an entity - like hive_table, hive_database. </summary>
    public partial class AtlasEntityHeader
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasEntityHeader"/>. </summary>
        public AtlasEntityHeader()
        {
            Attributes = new ChangeTrackingDictionary<string, BinaryData>();
            ClassificationNames = new ChangeTrackingList<string>();
            Classifications = new ChangeTrackingList<AtlasClassification>();
            Labels = new ChangeTrackingList<string>();
            MeaningNames = new ChangeTrackingList<string>();
            Meanings = new ChangeTrackingList<AtlasTermAssignmentHeader>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasEntityHeader"/>. </summary>
        /// <param name="attributes"> The attributes of the struct. </param>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="lastModifiedTS"> ETag for concurrency control. </param>
        /// <param name="classificationNames"> An array of classification names. </param>
        /// <param name="classifications"> An array of classifications. </param>
        /// <param name="displayText"> The display text. </param>
        /// <param name="guid"> The GUID of the record. </param>
        /// <param name="isIncomplete"> Whether it is a shell entity. </param>
        /// <param name="labels"> labels. </param>
        /// <param name="meaningNames"> An array of meanings. </param>
        /// <param name="meanings"> An array of term assignment headers. </param>
        /// <param name="status">
        /// Status of the entity - can be active or deleted. Deleted entities are not
        /// removed.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasEntityHeader(IDictionary<string, BinaryData> attributes, string typeName, string lastModifiedTS, IList<string> classificationNames, IList<AtlasClassification> classifications, string displayText, string guid, bool? isIncomplete, IList<string> labels, IList<string> meaningNames, IList<AtlasTermAssignmentHeader> meanings, EntityStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Attributes = attributes;
            TypeName = typeName;
            LastModifiedTS = lastModifiedTS;
            ClassificationNames = classificationNames;
            Classifications = classifications;
            DisplayText = displayText;
            Guid = guid;
            IsIncomplete = isIncomplete;
            Labels = labels;
            MeaningNames = meaningNames;
            Meanings = meanings;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The attributes of the struct.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> Attributes { get; }
        /// <summary> The name of the type. </summary>
        public string TypeName { get; set; }
        /// <summary> ETag for concurrency control. </summary>
        public string LastModifiedTS { get; set; }
        /// <summary> An array of classification names. </summary>
        public IList<string> ClassificationNames { get; }
        /// <summary> An array of classifications. </summary>
        public IList<AtlasClassification> Classifications { get; }
        /// <summary> The display text. </summary>
        public string DisplayText { get; set; }
        /// <summary> The GUID of the record. </summary>
        public string Guid { get; set; }
        /// <summary> Whether it is a shell entity. </summary>
        public bool? IsIncomplete { get; set; }
        /// <summary> labels. </summary>
        public IList<string> Labels { get; }
        /// <summary> An array of meanings. </summary>
        public IList<string> MeaningNames { get; }
        /// <summary> An array of term assignment headers. </summary>
        public IList<AtlasTermAssignmentHeader> Meanings { get; }
        /// <summary>
        /// Status of the entity - can be active or deleted. Deleted entities are not
        /// removed.
        /// </summary>
        public EntityStatus? Status { get; set; }
    }
}
