// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary>
    /// An instance of an entity along with extended info - like hive_table,
    /// hive_database.
    /// </summary>
    public partial class AtlasEntitiesWithExtInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasEntitiesWithExtInfo"/>. </summary>
        public AtlasEntitiesWithExtInfo()
        {
            ReferredEntities = new ChangeTrackingDictionary<string, AtlasEntity>();
            Entities = new ChangeTrackingList<AtlasEntity>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasEntitiesWithExtInfo"/>. </summary>
        /// <param name="referredEntities"> The referred entities. </param>
        /// <param name="entities"> An array of entities. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasEntitiesWithExtInfo(IDictionary<string, AtlasEntity> referredEntities, IList<AtlasEntity> entities, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ReferredEntities = referredEntities;
            Entities = entities;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The referred entities. </summary>
        public IDictionary<string, AtlasEntity> ReferredEntities { get; }
        /// <summary> An array of entities. </summary>
        public IList<AtlasEntity> Entities { get; }
    }
}
