// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> REST serialization friendly list. </summary>
    public partial class AtlasClassifications
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasClassifications"/>. </summary>
        internal AtlasClassifications()
        {
            List = new ChangeTrackingList<BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasClassifications"/>. </summary>
        /// <param name="list"> An array of objects. </param>
        /// <param name="pageSize"> The size of the page. </param>
        /// <param name="sortBy"> The sorted by field. </param>
        /// <param name="sortType"> to specify whether the result should be sorted? If yes, whether asc or desc. </param>
        /// <param name="startIndex"> The start index of the page. </param>
        /// <param name="totalCount"> The total count of items. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasClassifications(IReadOnlyList<BinaryData> list, int? pageSize, string sortBy, AtlasSortType? sortType, int? startIndex, int? totalCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            List = list;
            PageSize = pageSize;
            SortBy = sortBy;
            SortType = sortType;
            StartIndex = startIndex;
            TotalCount = totalCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// An array of objects.
        /// <para>
        /// To assign an object to the element of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IReadOnlyList<BinaryData> List { get; }
        /// <summary> The size of the page. </summary>
        public int? PageSize { get; }
        /// <summary> The sorted by field. </summary>
        public string SortBy { get; }
        /// <summary> to specify whether the result should be sorted? If yes, whether asc or desc. </summary>
        public AtlasSortType? SortType { get; }
        /// <summary> The start index of the page. </summary>
        public int? StartIndex { get; }
        /// <summary> The total count of items. </summary>
        public int? TotalCount { get; }
    }
}
