// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary>
    /// An instance of a classification; it doesn't have an identity, this object
    /// exists only when associated with an entity.
    /// </summary>
    public partial class AtlasClassification
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasClassification"/>. </summary>
        public AtlasClassification()
        {
            Attributes = new ChangeTrackingDictionary<string, BinaryData>();
            ValidityPeriods = new ChangeTrackingList<TimeBoundary>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasClassification"/>. </summary>
        /// <param name="attributes"> The attributes of the struct. </param>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="lastModifiedTS"> ETag for concurrency control. </param>
        /// <param name="entityGuid"> The GUID of the entity. </param>
        /// <param name="entityStatus">
        /// Status of the entity - can be active or deleted. Deleted entities are not
        /// removed.
        /// </param>
        /// <param name="removePropagationsOnEntityDelete"> Determines if propagations will be removed on entity deletion. </param>
        /// <param name="validityPeriods"> An array of time boundaries indicating validity periods. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasClassification(IDictionary<string, BinaryData> attributes, string typeName, string lastModifiedTS, string entityGuid, EntityStatus? entityStatus, bool? removePropagationsOnEntityDelete, IList<TimeBoundary> validityPeriods, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Attributes = attributes;
            TypeName = typeName;
            LastModifiedTS = lastModifiedTS;
            EntityGuid = entityGuid;
            EntityStatus = entityStatus;
            RemovePropagationsOnEntityDelete = removePropagationsOnEntityDelete;
            ValidityPeriods = validityPeriods;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The attributes of the struct.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> Attributes { get; }
        /// <summary> The name of the type. </summary>
        public string TypeName { get; set; }
        /// <summary> ETag for concurrency control. </summary>
        public string LastModifiedTS { get; set; }
        /// <summary> The GUID of the entity. </summary>
        public string EntityGuid { get; set; }
        /// <summary>
        /// Status of the entity - can be active or deleted. Deleted entities are not
        /// removed.
        /// </summary>
        public EntityStatus? EntityStatus { get; set; }
        /// <summary> Determines if propagations will be removed on entity deletion. </summary>
        public bool? RemovePropagationsOnEntityDelete { get; set; }
        /// <summary> An array of time boundaries indicating validity periods. </summary>
        public IList<TimeBoundary> ValidityPeriods { get; }
    }
}
