// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> class that captures details of a struct-attribute. </summary>
    public partial class AtlasAttributeDef
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasAttributeDef"/>. </summary>
        public AtlasAttributeDef()
        {
            Constraints = new ChangeTrackingList<AtlasConstraintDef>();
            Options = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasAttributeDef"/>. </summary>
        /// <param name="cardinality"> single-valued attribute or multi-valued attribute. </param>
        /// <param name="constraints"> An array of constraints. </param>
        /// <param name="defaultValue"> The default value of the attribute. </param>
        /// <param name="description"> The description of the attribute. </param>
        /// <param name="includeInNotification"> Determines if it is included in notification. </param>
        /// <param name="isIndexable"> Determines if it is indexable. </param>
        /// <param name="isOptional"> Determines if it is optional. </param>
        /// <param name="isUnique"> Determines if it unique. </param>
        /// <param name="name"> The name of the attribute. </param>
        /// <param name="options"> The options for the attribute. </param>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="valuesMaxCount"> The maximum count of the values. </param>
        /// <param name="valuesMinCount"> The minimum count of the values. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasAttributeDef(CardinalityValue? cardinality, IList<AtlasConstraintDef> constraints, string defaultValue, string description, bool? includeInNotification, bool? isIndexable, bool? isOptional, bool? isUnique, string name, IDictionary<string, string> options, string typeName, int? valuesMaxCount, int? valuesMinCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Cardinality = cardinality;
            Constraints = constraints;
            DefaultValue = defaultValue;
            Description = description;
            IncludeInNotification = includeInNotification;
            IsIndexable = isIndexable;
            IsOptional = isOptional;
            IsUnique = isUnique;
            Name = name;
            Options = options;
            TypeName = typeName;
            ValuesMaxCount = valuesMaxCount;
            ValuesMinCount = valuesMinCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> single-valued attribute or multi-valued attribute. </summary>
        public CardinalityValue? Cardinality { get; set; }
        /// <summary> An array of constraints. </summary>
        public IList<AtlasConstraintDef> Constraints { get; }
        /// <summary> The default value of the attribute. </summary>
        public string DefaultValue { get; set; }
        /// <summary> The description of the attribute. </summary>
        public string Description { get; set; }
        /// <summary> Determines if it is included in notification. </summary>
        public bool? IncludeInNotification { get; set; }
        /// <summary> Determines if it is indexable. </summary>
        public bool? IsIndexable { get; set; }
        /// <summary> Determines if it is optional. </summary>
        public bool? IsOptional { get; set; }
        /// <summary> Determines if it unique. </summary>
        public bool? IsUnique { get; set; }
        /// <summary> The name of the attribute. </summary>
        public string Name { get; set; }
        /// <summary> The options for the attribute. </summary>
        public IDictionary<string, string> Options { get; }
        /// <summary> The name of the type. </summary>
        public string TypeName { get; set; }
        /// <summary> The maximum count of the values. </summary>
        public int? ValuesMaxCount { get; set; }
        /// <summary> The minimum count of the values. </summary>
        public int? ValuesMinCount { get; set; }
    }
}
