// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Analytics.Purview.DataMap;
using Azure.Core.Extensions;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="DataMapClient"/> to client builder. </summary>
    public static partial class AnalyticsPurviewDataMapClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="DataMapClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The <see cref="Uri"/> to use. </param>
        public static IAzureClientBuilder<DataMapClient, DataMapClientOptions> AddDataMapClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<DataMapClient, DataMapClientOptions>((options, cred) => new DataMapClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="DataMapClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<DataMapClient, DataMapClientOptions> AddDataMapClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<DataMapClient, DataMapClientOptions>(configuration);
        }
    }
}
