// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Catalog.Samples
{
    public partial class Samples_PurviewTypes
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetBusinessMetadataDefByGuid_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetBusinessMetadataDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetBusinessMetadataDefByGuid_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetBusinessMetadataDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetBusinessMetadataDefByGuid_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetBusinessMetadataDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetBusinessMetadataDefByGuid_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetBusinessMetadataDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetBusinessMetadataDefByName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetBusinessMetadataDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetBusinessMetadataDefByName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetBusinessMetadataDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetBusinessMetadataDefByName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetBusinessMetadataDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetBusinessMetadataDefByName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetBusinessMetadataDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetClassificationDefByGuid_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetClassificationDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetClassificationDefByGuid_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetClassificationDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetClassificationDefByGuid_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetClassificationDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetClassificationDefByGuid_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetClassificationDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetClassificationDefByName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetClassificationDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetClassificationDefByName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetClassificationDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetClassificationDefByName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetClassificationDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetClassificationDefByName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetClassificationDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEntityDefinitionByGuid_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetEntityDefinitionByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEntityDefinitionByGuid_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetEntityDefinitionByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEntityDefinitionByGuid_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetEntityDefinitionByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEntityDefinitionByGuid_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetEntityDefinitionByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEntityDefinitionByName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetEntityDefinitionByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEntityDefinitionByName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetEntityDefinitionByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEntityDefinitionByName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetEntityDefinitionByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEntityDefinitionByName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetEntityDefinitionByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEnumDefByGuid_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetEnumDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEnumDefByGuid_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetEnumDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEnumDefByGuid_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetEnumDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEnumDefByGuid_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetEnumDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEnumDefByName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetEnumDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEnumDefByName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetEnumDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEnumDefByName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetEnumDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEnumDefByName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetEnumDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRelationshipDefByGuid_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetRelationshipDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRelationshipDefByGuid_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetRelationshipDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRelationshipDefByGuid_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetRelationshipDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRelationshipDefByGuid_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetRelationshipDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRelationshipDefByName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetRelationshipDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRelationshipDefByName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetRelationshipDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRelationshipDefByName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetRelationshipDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRelationshipDefByName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetRelationshipDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetStructDefByGuid_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetStructDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetStructDefByGuid_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetStructDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetStructDefByGuid_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetStructDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetStructDefByGuid_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetStructDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetStructDefByName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetStructDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetStructDefByName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetStructDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetStructDefByName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetStructDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetStructDefByName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetStructDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTypeDefinitionByGuid_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetTypeDefinitionByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTypeDefinitionByGuid_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetTypeDefinitionByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTypeDefinitionByGuid_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetTypeDefinitionByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTypeDefinitionByGuid_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetTypeDefinitionByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTypeDefinitionByName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetTypeDefinitionByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTypeDefinitionByName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetTypeDefinitionByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTypeDefinitionByName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetTypeDefinitionByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTypeDefinitionByName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetTypeDefinitionByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteTypeByName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.DeleteTypeByName("<name>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteTypeByName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.DeleteTypeByNameAsync("<name>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteTypeByName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.DeleteTypeByName("<name>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteTypeByName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.DeleteTypeByNameAsync("<name>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAllTypeDefinitions_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetAllTypeDefinitions(null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAllTypeDefinitions_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetAllTypeDefinitionsAsync(null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAllTypeDefinitions_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetAllTypeDefinitions(true, "enum", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAllTypeDefinitions_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetAllTypeDefinitionsAsync(true, "enum", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateTypeDefinitions_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.CreateTypeDefinitions(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateTypeDefinitions_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.CreateTypeDefinitionsAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateTypeDefinitions_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new
            {
                businessMetadataDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
new
{
cardinality = "SINGLE",
constraints = new object[]
{
new Dictionary<string, object>
{
["params"] = new
{
key = new object(),
},
["type"] = "<type>"
}
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
dateFormatter = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
calendar = 123.45F,
lenient = true,
numberFormat = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
currency = "<currency>",
groupingUsed = true,
maximumFractionDigits = 1234,
maximumIntegerDigits = 1234,
minimumFractionDigits = 1234,
minimumIntegerDigits = 1234,
parseIntegerOnly = true,
roundingMode = "UP",
},
timeZone = new Dictionary<string, object>
{
["dstSavings"] = 1234,
["id"] = "<id>",
["availableIds"] = new object[]
{
"<availableIds>"
},
["default"] = null,
["displayName"] = "<displayName>",
["rawOffset"] = 1234
},
},
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                classificationDefs = new object[]
            {
new
{
entityTypes = new object[]
{
"<entityTypes>"
},
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                entityDefs = new object[]
            {
new
{
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
relationshipAttributeDefs = new object[]
{
new
{
isLegacyAttribute = true,
relationshipTypeName = "<relationshipTypeName>",
cardinality = "SINGLE",
constraints = new object[]
{
null
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                enumDefs = new object[]
            {
new
{
defaultValue = "<defaultValue>",
elementDefs = new object[]
{
new
{
description = "<description>",
ordinal = 123.45F,
value = "<value>",
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                relationshipDefs = new object[]
            {
new
{
endDef1 = new
{
cardinality = "SINGLE",
description = "<description>",
isContainer = true,
isLegacyAttribute = true,
name = "<name>",
type = "<type>",
},
relationshipCategory = "ASSOCIATION",
relationshipLabel = "<relationshipLabel>",
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                structDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                termTemplateDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
            });
            Response response = client.CreateTypeDefinitions(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateTypeDefinitions_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new
            {
                businessMetadataDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
new
{
cardinality = "SINGLE",
constraints = new object[]
{
new Dictionary<string, object>
{
["params"] = new
{
key = new object(),
},
["type"] = "<type>"
}
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
dateFormatter = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
calendar = 123.45F,
lenient = true,
numberFormat = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
currency = "<currency>",
groupingUsed = true,
maximumFractionDigits = 1234,
maximumIntegerDigits = 1234,
minimumFractionDigits = 1234,
minimumIntegerDigits = 1234,
parseIntegerOnly = true,
roundingMode = "UP",
},
timeZone = new Dictionary<string, object>
{
["dstSavings"] = 1234,
["id"] = "<id>",
["availableIds"] = new object[]
{
"<availableIds>"
},
["default"] = null,
["displayName"] = "<displayName>",
["rawOffset"] = 1234
},
},
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                classificationDefs = new object[]
            {
new
{
entityTypes = new object[]
{
"<entityTypes>"
},
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                entityDefs = new object[]
            {
new
{
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
relationshipAttributeDefs = new object[]
{
new
{
isLegacyAttribute = true,
relationshipTypeName = "<relationshipTypeName>",
cardinality = "SINGLE",
constraints = new object[]
{
null
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                enumDefs = new object[]
            {
new
{
defaultValue = "<defaultValue>",
elementDefs = new object[]
{
new
{
description = "<description>",
ordinal = 123.45F,
value = "<value>",
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                relationshipDefs = new object[]
            {
new
{
endDef1 = new
{
cardinality = "SINGLE",
description = "<description>",
isContainer = true,
isLegacyAttribute = true,
name = "<name>",
type = "<type>",
},
relationshipCategory = "ASSOCIATION",
relationshipLabel = "<relationshipLabel>",
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                structDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                termTemplateDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
            });
            Response response = await client.CreateTypeDefinitionsAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateAtlasTypeDefinitions_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.UpdateAtlasTypeDefinitions(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateAtlasTypeDefinitions_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.UpdateAtlasTypeDefinitionsAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateAtlasTypeDefinitions_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new
            {
                businessMetadataDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
new
{
cardinality = "SINGLE",
constraints = new object[]
{
new Dictionary<string, object>
{
["params"] = new
{
key = new object(),
},
["type"] = "<type>"
}
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
dateFormatter = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
calendar = 123.45F,
lenient = true,
numberFormat = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
currency = "<currency>",
groupingUsed = true,
maximumFractionDigits = 1234,
maximumIntegerDigits = 1234,
minimumFractionDigits = 1234,
minimumIntegerDigits = 1234,
parseIntegerOnly = true,
roundingMode = "UP",
},
timeZone = new Dictionary<string, object>
{
["dstSavings"] = 1234,
["id"] = "<id>",
["availableIds"] = new object[]
{
"<availableIds>"
},
["default"] = null,
["displayName"] = "<displayName>",
["rawOffset"] = 1234
},
},
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                classificationDefs = new object[]
            {
new
{
entityTypes = new object[]
{
"<entityTypes>"
},
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                entityDefs = new object[]
            {
new
{
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
relationshipAttributeDefs = new object[]
{
new
{
isLegacyAttribute = true,
relationshipTypeName = "<relationshipTypeName>",
cardinality = "SINGLE",
constraints = new object[]
{
null
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                enumDefs = new object[]
            {
new
{
defaultValue = "<defaultValue>",
elementDefs = new object[]
{
new
{
description = "<description>",
ordinal = 123.45F,
value = "<value>",
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                relationshipDefs = new object[]
            {
new
{
endDef1 = new
{
cardinality = "SINGLE",
description = "<description>",
isContainer = true,
isLegacyAttribute = true,
name = "<name>",
type = "<type>",
},
relationshipCategory = "ASSOCIATION",
relationshipLabel = "<relationshipLabel>",
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                structDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                termTemplateDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
            });
            Response response = client.UpdateAtlasTypeDefinitions(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateAtlasTypeDefinitions_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new
            {
                businessMetadataDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
new
{
cardinality = "SINGLE",
constraints = new object[]
{
new Dictionary<string, object>
{
["params"] = new
{
key = new object(),
},
["type"] = "<type>"
}
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
dateFormatter = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
calendar = 123.45F,
lenient = true,
numberFormat = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
currency = "<currency>",
groupingUsed = true,
maximumFractionDigits = 1234,
maximumIntegerDigits = 1234,
minimumFractionDigits = 1234,
minimumIntegerDigits = 1234,
parseIntegerOnly = true,
roundingMode = "UP",
},
timeZone = new Dictionary<string, object>
{
["dstSavings"] = 1234,
["id"] = "<id>",
["availableIds"] = new object[]
{
"<availableIds>"
},
["default"] = null,
["displayName"] = "<displayName>",
["rawOffset"] = 1234
},
},
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                classificationDefs = new object[]
            {
new
{
entityTypes = new object[]
{
"<entityTypes>"
},
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                entityDefs = new object[]
            {
new
{
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
relationshipAttributeDefs = new object[]
{
new
{
isLegacyAttribute = true,
relationshipTypeName = "<relationshipTypeName>",
cardinality = "SINGLE",
constraints = new object[]
{
null
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                enumDefs = new object[]
            {
new
{
defaultValue = "<defaultValue>",
elementDefs = new object[]
{
new
{
description = "<description>",
ordinal = 123.45F,
value = "<value>",
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                relationshipDefs = new object[]
            {
new
{
endDef1 = new
{
cardinality = "SINGLE",
description = "<description>",
isContainer = true,
isLegacyAttribute = true,
name = "<name>",
type = "<type>",
},
relationshipCategory = "ASSOCIATION",
relationshipLabel = "<relationshipLabel>",
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                structDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                termTemplateDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
            });
            Response response = await client.UpdateAtlasTypeDefinitionsAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("businessMetadataDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("entityTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("classificationDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("subTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("superTypes")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("relationshipTypeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("relationshipAttributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("entityDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("ordinal").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("elementDefs")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("enumDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef1").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isContainer").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("isLegacyAttribute").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("endDef2").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipCategory").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("relationshipLabel").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("relationshipDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("structDefs")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("termTemplateDefs")[0].GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteTypeDefinitions_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.DeleteTypeDefinitions(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteTypeDefinitions_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.DeleteTypeDefinitionsAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteTypeDefinitions_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new
            {
                businessMetadataDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
new
{
cardinality = "SINGLE",
constraints = new object[]
{
new Dictionary<string, object>
{
["params"] = new
{
key = new object(),
},
["type"] = "<type>"
}
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
dateFormatter = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
calendar = 123.45F,
lenient = true,
numberFormat = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
currency = "<currency>",
groupingUsed = true,
maximumFractionDigits = 1234,
maximumIntegerDigits = 1234,
minimumFractionDigits = 1234,
minimumIntegerDigits = 1234,
parseIntegerOnly = true,
roundingMode = "UP",
},
timeZone = new Dictionary<string, object>
{
["dstSavings"] = 1234,
["id"] = "<id>",
["availableIds"] = new object[]
{
"<availableIds>"
},
["default"] = null,
["displayName"] = "<displayName>",
["rawOffset"] = 1234
},
},
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                classificationDefs = new object[]
            {
new
{
entityTypes = new object[]
{
"<entityTypes>"
},
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                entityDefs = new object[]
            {
new
{
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
relationshipAttributeDefs = new object[]
{
new
{
isLegacyAttribute = true,
relationshipTypeName = "<relationshipTypeName>",
cardinality = "SINGLE",
constraints = new object[]
{
null
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                enumDefs = new object[]
            {
new
{
defaultValue = "<defaultValue>",
elementDefs = new object[]
{
new
{
description = "<description>",
ordinal = 123.45F,
value = "<value>",
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                relationshipDefs = new object[]
            {
new
{
endDef1 = new
{
cardinality = "SINGLE",
description = "<description>",
isContainer = true,
isLegacyAttribute = true,
name = "<name>",
type = "<type>",
},
relationshipCategory = "ASSOCIATION",
relationshipLabel = "<relationshipLabel>",
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                structDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                termTemplateDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
            });
            Response response = client.DeleteTypeDefinitions(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteTypeDefinitions_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            using RequestContent content = RequestContent.Create(new
            {
                businessMetadataDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
new
{
cardinality = "SINGLE",
constraints = new object[]
{
new Dictionary<string, object>
{
["params"] = new
{
key = new object(),
},
["type"] = "<type>"
}
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
dateFormatter = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
calendar = 123.45F,
lenient = true,
numberFormat = new
{
availableLocales = new object[]
{
"<availableLocales>"
},
currency = "<currency>",
groupingUsed = true,
maximumFractionDigits = 1234,
maximumIntegerDigits = 1234,
minimumFractionDigits = 1234,
minimumIntegerDigits = 1234,
parseIntegerOnly = true,
roundingMode = "UP",
},
timeZone = new Dictionary<string, object>
{
["dstSavings"] = 1234,
["id"] = "<id>",
["availableIds"] = new object[]
{
"<availableIds>"
},
["default"] = null,
["displayName"] = "<displayName>",
["rawOffset"] = 1234
},
},
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                classificationDefs = new object[]
            {
new
{
entityTypes = new object[]
{
"<entityTypes>"
},
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                entityDefs = new object[]
            {
new
{
subTypes = new object[]
{
"<subTypes>"
},
superTypes = new object[]
{
"<superTypes>"
},
relationshipAttributeDefs = new object[]
{
new
{
isLegacyAttribute = true,
relationshipTypeName = "<relationshipTypeName>",
cardinality = "SINGLE",
constraints = new object[]
{
null
},
defaultValue = "<defaultValue>",
description = "<description>",
includeInNotification = true,
isIndexable = true,
isOptional = true,
isUnique = true,
name = "<name>",
options = new
{
key = "<options>",
},
typeName = "<typeName>",
valuesMaxCount = 1234,
valuesMinCount = 1234,
}
},
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                enumDefs = new object[]
            {
new
{
defaultValue = "<defaultValue>",
elementDefs = new object[]
{
new
{
description = "<description>",
ordinal = 123.45F,
value = "<value>",
}
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                relationshipDefs = new object[]
            {
new
{
endDef1 = new
{
cardinality = "SINGLE",
description = "<description>",
isContainer = true,
isLegacyAttribute = true,
name = "<name>",
type = "<type>",
},
relationshipCategory = "ASSOCIATION",
relationshipLabel = "<relationshipLabel>",
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                structDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
                termTemplateDefs = new object[]
            {
new
{
attributeDefs = new object[]
{
null
},
category = "PRIMITIVE",
createTime = 123.45F,
createdBy = "<createdBy>",
description = "<description>",
guid = "<guid>",
name = "<name>",
options = new
{
key = "<options>",
},
serviceType = "<serviceType>",
typeVersion = "<typeVersion>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
version = 123.45F,
lastModifiedTS = "<lastModifiedTS>",
}
            },
            });
            Response response = await client.DeleteTypeDefinitionsAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTypeDefinitionHeaders_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetTypeDefinitionHeaders(null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTypeDefinitionHeaders_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetTypeDefinitionHeadersAsync(null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTypeDefinitionHeaders_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetTypeDefinitionHeaders(true, "enum", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("category").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTypeDefinitionHeaders_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetTypeDefinitionHeadersAsync(true, "enum", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("category").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTermTemplateDefByGuid_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetTermTemplateDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTermTemplateDefByGuid_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetTermTemplateDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTermTemplateDefByGuid_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetTermTemplateDefByGuid("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTermTemplateDefByGuid_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetTermTemplateDefByGuidAsync("<guid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTermTemplateDefByName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetTermTemplateDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTermTemplateDefByName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetTermTemplateDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTermTemplateDefByName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = client.GetTermTemplateDefByName("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTermTemplateDefByName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewTypes client = new PurviewCatalogClient(endpoint, credential).GetPurviewTypesClient();

            Response response = await client.GetTermTemplateDefByNameAsync("<name>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("cardinality").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("params").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("constraints")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("defaultValue").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("includeInNotification").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isIndexable").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isOptional").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("isUnique").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMaxCount").ToString());
            Console.WriteLine(result.GetProperty("attributeDefs")[0].GetProperty("valuesMinCount").ToString());
            Console.WriteLine(result.GetProperty("category").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("calendar").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("lenient").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("availableLocales")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("currency").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("groupingUsed").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("maximumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumFractionDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("minimumIntegerDigits").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("parseIntegerOnly").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("numberFormat").GetProperty("roundingMode").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("dstSavings").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("availableIds")[0].ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("dateFormatter").GetProperty("timeZone").GetProperty("rawOffset").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("options").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("serviceType").ToString());
            Console.WriteLine(result.GetProperty("typeVersion").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }
    }
}
