// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Catalog.Samples
{
    public partial class Samples_PurviewRelationships
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Create_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Create(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Create_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.CreateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Create_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            using RequestContent content = RequestContent.Create(new
            {
                createTime = 123.45F,
                createdBy = "<createdBy>",
                end1 = new
                {
                    guid = "<guid>",
                    typeName = "<typeName>",
                    uniqueAttributes = new
                    {
                        key = new object(),
                    },
                },
                guid = "<guid>",
                homeId = "<homeId>",
                label = "<label>",
                provenanceType = 123.45F,
                status = "ACTIVE",
                updateTime = 123.45F,
                updatedBy = "<updatedBy>",
                version = 123.45F,
                attributes = new
                {
                    key = new object(),
                },
                typeName = "<typeName>",
                lastModifiedTS = "<lastModifiedTS>",
            });
            Response response = client.Create(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("homeId").ToString());
            Console.WriteLine(result.GetProperty("label").ToString());
            Console.WriteLine(result.GetProperty("provenanceType").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Create_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            using RequestContent content = RequestContent.Create(new
            {
                createTime = 123.45F,
                createdBy = "<createdBy>",
                end1 = new
                {
                    guid = "<guid>",
                    typeName = "<typeName>",
                    uniqueAttributes = new
                    {
                        key = new object(),
                    },
                },
                guid = "<guid>",
                homeId = "<homeId>",
                label = "<label>",
                provenanceType = 123.45F,
                status = "ACTIVE",
                updateTime = 123.45F,
                updatedBy = "<updatedBy>",
                version = 123.45F,
                attributes = new
                {
                    key = new object(),
                },
                typeName = "<typeName>",
                lastModifiedTS = "<lastModifiedTS>",
            });
            Response response = await client.CreateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("homeId").ToString());
            Console.WriteLine(result.GetProperty("label").ToString());
            Console.WriteLine(result.GetProperty("provenanceType").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Update_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Update(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Update_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.UpdateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Update_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            using RequestContent content = RequestContent.Create(new
            {
                createTime = 123.45F,
                createdBy = "<createdBy>",
                end1 = new
                {
                    guid = "<guid>",
                    typeName = "<typeName>",
                    uniqueAttributes = new
                    {
                        key = new object(),
                    },
                },
                guid = "<guid>",
                homeId = "<homeId>",
                label = "<label>",
                provenanceType = 123.45F,
                status = "ACTIVE",
                updateTime = 123.45F,
                updatedBy = "<updatedBy>",
                version = 123.45F,
                attributes = new
                {
                    key = new object(),
                },
                typeName = "<typeName>",
                lastModifiedTS = "<lastModifiedTS>",
            });
            Response response = client.Update(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("homeId").ToString());
            Console.WriteLine(result.GetProperty("label").ToString());
            Console.WriteLine(result.GetProperty("provenanceType").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Update_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            using RequestContent content = RequestContent.Create(new
            {
                createTime = 123.45F,
                createdBy = "<createdBy>",
                end1 = new
                {
                    guid = "<guid>",
                    typeName = "<typeName>",
                    uniqueAttributes = new
                    {
                        key = new object(),
                    },
                },
                guid = "<guid>",
                homeId = "<homeId>",
                label = "<label>",
                provenanceType = 123.45F,
                status = "ACTIVE",
                updateTime = 123.45F,
                updatedBy = "<updatedBy>",
                version = 123.45F,
                attributes = new
                {
                    key = new object(),
                },
                typeName = "<typeName>",
                lastModifiedTS = "<lastModifiedTS>",
            });
            Response response = await client.UpdateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("end1").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("end2").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("homeId").ToString());
            Console.WriteLine(result.GetProperty("label").ToString());
            Console.WriteLine(result.GetProperty("provenanceType").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetPurviewRelationship_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            Response response = client.GetPurviewRelationship("<guid>", null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetPurviewRelationship_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            Response response = await client.GetPurviewRelationshipAsync("<guid>", null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetPurviewRelationship_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            Response response = client.GetPurviewRelationship("<guid>", true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classificationNames")[0].ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("isIncomplete").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("labels")[0].ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meaningNames")[0].ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("confidence").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end1").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end1").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end1").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end2").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end2").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end2").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("homeId").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("label").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("provenanceType").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetPurviewRelationship_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            Response response = await client.GetPurviewRelationshipAsync("<guid>", true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classificationNames")[0].ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("isIncomplete").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("labels")[0].ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meaningNames")[0].ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("confidence").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("referredEntities").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end1").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end1").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end1").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end2").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end2").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("end2").GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("homeId").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("label").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("provenanceType").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("relationship").GetProperty("lastModifiedTS").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Delete_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            Response response = client.Delete("<guid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Delete_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            Response response = await client.DeleteAsync("<guid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Delete_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            Response response = client.Delete("<guid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Delete_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewRelationships client = new PurviewCatalogClient(endpoint, credential).GetPurviewRelationshipsClient();

            Response response = await client.DeleteAsync("<guid>");

            Console.WriteLine(response.Status);
        }
    }
}
