// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Catalog.Samples
{
    public partial class Samples_PurviewLineages
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLineageGraph_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = client.GetLineageGraph("<guid>", "BOTH", null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLineageGraph_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = await client.GetLineageGraphAsync("<guid>", "BOTH", null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLineageGraph_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = client.GetLineageGraph("<guid>", "BOTH", 1234, 1234, true, true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("baseEntityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classificationNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("isIncomplete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("labels")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meaningNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("confidence").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("widthCounts").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("lineageDepth").ToString());
            Console.WriteLine(result.GetProperty("lineageWidth").ToString());
            Console.WriteLine(result.GetProperty("includeParent").ToString());
            Console.WriteLine(result.GetProperty("childrenCount").ToString());
            Console.WriteLine(result.GetProperty("lineageDirection").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("childEntityId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("parentEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("fromEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("toEntityId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLineageGraph_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = await client.GetLineageGraphAsync("<guid>", "BOTH", 1234, 1234, true, true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("baseEntityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classificationNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("isIncomplete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("labels")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meaningNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("confidence").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("widthCounts").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("lineageDepth").ToString());
            Console.WriteLine(result.GetProperty("lineageWidth").ToString());
            Console.WriteLine(result.GetProperty("includeParent").ToString());
            Console.WriteLine(result.GetProperty("childrenCount").ToString());
            Console.WriteLine(result.GetProperty("lineageDirection").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("childEntityId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("parentEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("fromEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("toEntityId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_NextPageLineage_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = client.NextPageLineage("<guid>", "BOTH", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_NextPageLineage_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = await client.NextPageLineageAsync("<guid>", "BOTH", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_NextPageLineage_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = client.NextPageLineage("<guid>", "BOTH", true, 1234, 1234, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("baseEntityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classificationNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("isIncomplete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("labels")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meaningNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("confidence").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("widthCounts").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("lineageDepth").ToString());
            Console.WriteLine(result.GetProperty("lineageWidth").ToString());
            Console.WriteLine(result.GetProperty("includeParent").ToString());
            Console.WriteLine(result.GetProperty("childrenCount").ToString());
            Console.WriteLine(result.GetProperty("lineageDirection").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("childEntityId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("parentEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("fromEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("toEntityId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_NextPageLineage_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = await client.NextPageLineageAsync("<guid>", "BOTH", true, 1234, 1234, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("baseEntityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classificationNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("isIncomplete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("labels")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meaningNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("confidence").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("widthCounts").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("lineageDepth").ToString());
            Console.WriteLine(result.GetProperty("lineageWidth").ToString());
            Console.WriteLine(result.GetProperty("includeParent").ToString());
            Console.WriteLine(result.GetProperty("childrenCount").ToString());
            Console.WriteLine(result.GetProperty("lineageDirection").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("childEntityId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("parentEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("fromEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("toEntityId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLineageByUniqueAttribute_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = client.GetLineageByUniqueAttribute("<typeName>", "BOTH", null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLineageByUniqueAttribute_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = await client.GetLineageByUniqueAttributeAsync("<typeName>", "BOTH", null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLineageByUniqueAttribute_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = client.GetLineageByUniqueAttribute("<typeName>", "BOTH", 1234, 1234, true, true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("baseEntityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classificationNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("isIncomplete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("labels")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meaningNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("confidence").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("widthCounts").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("lineageDepth").ToString());
            Console.WriteLine(result.GetProperty("lineageWidth").ToString());
            Console.WriteLine(result.GetProperty("includeParent").ToString());
            Console.WriteLine(result.GetProperty("childrenCount").ToString());
            Console.WriteLine(result.GetProperty("lineageDirection").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("childEntityId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("parentEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("fromEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("toEntityId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLineageByUniqueAttribute_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewLineages client = new PurviewCatalogClient(endpoint, credential).GetPurviewLineagesClient();

            Response response = await client.GetLineageByUniqueAttributeAsync("<typeName>", "BOTH", 1234, 1234, true, true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("baseEntityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classificationNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("isIncomplete").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("labels")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meaningNames")[0].ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("confidence").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("meanings")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("guidEntityMap").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("widthCounts").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("lineageDepth").ToString());
            Console.WriteLine(result.GetProperty("lineageWidth").ToString());
            Console.WriteLine(result.GetProperty("includeParent").ToString());
            Console.WriteLine(result.GetProperty("childrenCount").ToString());
            Console.WriteLine(result.GetProperty("lineageDirection").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("childEntityId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("parentRelations")[0].GetProperty("parentEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("fromEntityId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("relationshipId").ToString());
            Console.WriteLine(result.GetProperty("relations")[0].GetProperty("toEntityId").ToString());
        }
    }
}
