// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.IO;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Catalog.Samples
{
    public partial class Samples_PurviewGlossaries
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaries_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaries(null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaries_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossariesAsync(null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaries_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaries(1234, 1234, "<sort>", true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("language").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("usage").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaries_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossariesAsync(1234, 1234, "<sort>", true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("language").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("usage").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateGlossary_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.CreateGlossary(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateGlossary_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.CreateGlossaryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateGlossary_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                categories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
parentCategoryGuid = "<parentCategoryGuid>",
relationGuid = "<relationGuid>",
}
            },
                language = "<language>",
                terms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                usage = "<usage>",
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = client.CreateGlossary(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("language").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateGlossary_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                categories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
parentCategoryGuid = "<parentCategoryGuid>",
relationGuid = "<relationGuid>",
}
            },
                language = "<language>",
                terms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                usage = "<usage>",
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = await client.CreateGlossaryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("language").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateGlossaryCategories_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new object()
            });
            Response response = client.CreateGlossaryCategories(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateGlossaryCategories_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new object()
            });
            Response response = await client.CreateGlossaryCategoriesAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateGlossaryCategories_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
anchor = new
{
displayText = "<displayText>",
glossaryGuid = "<glossaryGuid>",
relationGuid = "<relationGuid>",
},
childrenCategories = new object[]
{
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
parentCategoryGuid = "<parentCategoryGuid>",
relationGuid = "<relationGuid>",
}
},
terms = new object[]
{
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
},
classifications = new object[]
{
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
},
longDescription = "<longDescription>",
name = "<name>",
qualifiedName = "<qualifiedName>",
shortDescription = "<shortDescription>",
lastModifiedTS = "<lastModifiedTS>",
guid = "<guid>",
}
            });
            Response response = client.CreateGlossaryCategories(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateGlossaryCategories_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
anchor = new
{
displayText = "<displayText>",
glossaryGuid = "<glossaryGuid>",
relationGuid = "<relationGuid>",
},
childrenCategories = new object[]
{
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
parentCategoryGuid = "<parentCategoryGuid>",
relationGuid = "<relationGuid>",
}
},
terms = new object[]
{
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
},
classifications = new object[]
{
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
},
longDescription = "<longDescription>",
name = "<name>",
qualifiedName = "<qualifiedName>",
shortDescription = "<shortDescription>",
lastModifiedTS = "<lastModifiedTS>",
guid = "<guid>",
}
            });
            Response response = await client.CreateGlossaryCategoriesAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateGlossaryCategory_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.CreateGlossaryCategory(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateGlossaryCategory_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.CreateGlossaryCategoryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateGlossaryCategory_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                anchor = new
                {
                    displayText = "<displayText>",
                    glossaryGuid = "<glossaryGuid>",
                    relationGuid = "<relationGuid>",
                },
                childrenCategories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
parentCategoryGuid = "<parentCategoryGuid>",
relationGuid = "<relationGuid>",
}
            },
                terms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = client.CreateGlossaryCategory(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateGlossaryCategory_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                anchor = new
                {
                    displayText = "<displayText>",
                    glossaryGuid = "<glossaryGuid>",
                    relationGuid = "<relationGuid>",
                },
                childrenCategories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
parentCategoryGuid = "<parentCategoryGuid>",
relationGuid = "<relationGuid>",
}
            },
                terms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = await client.CreateGlossaryCategoryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryCategory_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryCategory("<categoryGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryCategory_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryCategoryAsync("<categoryGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryCategory_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryCategory("<categoryGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryCategory_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryCategoryAsync("<categoryGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateGlossaryCategory_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.UpdateGlossaryCategory("<categoryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateGlossaryCategory_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.UpdateGlossaryCategoryAsync("<categoryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateGlossaryCategory_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                anchor = new
                {
                    displayText = "<displayText>",
                    glossaryGuid = "<glossaryGuid>",
                    relationGuid = "<relationGuid>",
                },
                childrenCategories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
parentCategoryGuid = "<parentCategoryGuid>",
relationGuid = "<relationGuid>",
}
            },
                terms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = client.UpdateGlossaryCategory("<categoryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateGlossaryCategory_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                anchor = new
                {
                    displayText = "<displayText>",
                    glossaryGuid = "<glossaryGuid>",
                    relationGuid = "<relationGuid>",
                },
                childrenCategories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
parentCategoryGuid = "<parentCategoryGuid>",
relationGuid = "<relationGuid>",
}
            },
                terms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = await client.UpdateGlossaryCategoryAsync("<categoryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteGlossaryCategory_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.DeleteGlossaryCategory("<categoryGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteGlossaryCategory_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.DeleteGlossaryCategoryAsync("<categoryGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteGlossaryCategory_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.DeleteGlossaryCategory("<categoryGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteGlossaryCategory_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.DeleteGlossaryCategoryAsync("<categoryGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_PartialUpdateGlossaryCategory_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = client.PartialUpdateGlossaryCategory("<categoryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_PartialUpdateGlossaryCategory_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = await client.PartialUpdateGlossaryCategoryAsync("<categoryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_PartialUpdateGlossaryCategory_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = client.PartialUpdateGlossaryCategory("<categoryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_PartialUpdateGlossaryCategory_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = await client.PartialUpdateGlossaryCategoryAsync("<categoryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRelatedCategories_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetRelatedCategories("<categoryGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRelatedCategories_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetRelatedCategoriesAsync("<categoryGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRelatedCategories_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetRelatedCategories("<categoryGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("relationGuid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRelatedCategories_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetRelatedCategoriesAsync("<categoryGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("relationGuid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetCategoryTerms_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetCategoryTerms("<categoryGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetCategoryTerms_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetCategoryTermsAsync("<categoryGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetCategoryTerms_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetCategoryTerms("<categoryGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("termGuid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetCategoryTerms_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetCategoryTermsAsync("<categoryGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("termGuid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateGlossaryTerm_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.CreateGlossaryTerm(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateGlossaryTerm_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.CreateGlossaryTermAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateGlossaryTerm_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                abbreviation = "<abbreviation>",
                templateName = new object[]
            {
new object()
            },
                anchor = new
                {
                    displayText = "<displayText>",
                    glossaryGuid = "<glossaryGuid>",
                    relationGuid = "<relationGuid>",
                },
                antonyms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                createTime = 123.45F,
                createdBy = "<createdBy>",
                updateTime = 123.45F,
                updatedBy = "<updatedBy>",
                status = "Draft",
                resources = new object[]
            {
new
{
displayName = "<displayName>",
url = "<url>",
}
            },
                contacts = new
                {
                    key = new object[]
            {
new
{
id = "<id>",
info = "<info>",
}
            },
                },
                attributes = new
                {
                    key = new
                    {
                        key = new object(),
                    },
                },
                assignedEntities = new object[]
            {
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
            },
                categories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
relationGuid = "<relationGuid>",
status = "DRAFT",
}
            },
                classifies = new object[]
            {
null
            },
                examples = new object[]
            {
"<examples>"
            },
                isA = new object[]
            {
null
            },
                preferredTerms = new object[]
            {
null
            },
                preferredToTerms = new object[]
            {
null
            },
                replacedBy = new object[]
            {
null
            },
                replacementTerms = new object[]
            {
null
            },
                seeAlso = new object[]
            {
null
            },
                synonyms = new object[]
            {
null
            },
                translatedTerms = new object[]
            {
null
            },
                translationTerms = new object[]
            {
null
            },
                usage = "<usage>",
                validValues = new object[]
            {
null
            },
                validValuesFor = new object[]
            {
null
            },
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = client.CreateGlossaryTerm(content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("abbreviation").ToString());
            Console.WriteLine(result.GetProperty("templateName")[0].ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("examples")[0].ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateGlossaryTerm_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                abbreviation = "<abbreviation>",
                templateName = new object[]
            {
new object()
            },
                anchor = new
                {
                    displayText = "<displayText>",
                    glossaryGuid = "<glossaryGuid>",
                    relationGuid = "<relationGuid>",
                },
                antonyms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                createTime = 123.45F,
                createdBy = "<createdBy>",
                updateTime = 123.45F,
                updatedBy = "<updatedBy>",
                status = "Draft",
                resources = new object[]
            {
new
{
displayName = "<displayName>",
url = "<url>",
}
            },
                contacts = new
                {
                    key = new object[]
            {
new
{
id = "<id>",
info = "<info>",
}
            },
                },
                attributes = new
                {
                    key = new
                    {
                        key = new object(),
                    },
                },
                assignedEntities = new object[]
            {
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
            },
                categories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
relationGuid = "<relationGuid>",
status = "DRAFT",
}
            },
                classifies = new object[]
            {
null
            },
                examples = new object[]
            {
"<examples>"
            },
                isA = new object[]
            {
null
            },
                preferredTerms = new object[]
            {
null
            },
                preferredToTerms = new object[]
            {
null
            },
                replacedBy = new object[]
            {
null
            },
                replacementTerms = new object[]
            {
null
            },
                seeAlso = new object[]
            {
null
            },
                synonyms = new object[]
            {
null
            },
                translatedTerms = new object[]
            {
null
            },
                translationTerms = new object[]
            {
null
            },
                usage = "<usage>",
                validValues = new object[]
            {
null
            },
                validValuesFor = new object[]
            {
null
            },
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = await client.CreateGlossaryTermAsync(content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("abbreviation").ToString());
            Console.WriteLine(result.GetProperty("templateName")[0].ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("examples")[0].ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryTerm_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryTerm("<termGuid>", null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryTerm_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryTermAsync("<termGuid>", null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryTerm_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryTerm("<termGuid>", true, new string[] { "<excludeRelationshipTypeList>" }, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("abbreviation").ToString());
            Console.WriteLine(result.GetProperty("templateName")[0].ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("examples")[0].ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryTerm_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryTermAsync("<termGuid>", true, new string[] { "<excludeRelationshipTypeList>" }, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("abbreviation").ToString());
            Console.WriteLine(result.GetProperty("templateName")[0].ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("examples")[0].ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateGlossaryTerm_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.UpdateGlossaryTerm("<termGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateGlossaryTerm_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.UpdateGlossaryTermAsync("<termGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateGlossaryTerm_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                abbreviation = "<abbreviation>",
                templateName = new object[]
            {
new object()
            },
                anchor = new
                {
                    displayText = "<displayText>",
                    glossaryGuid = "<glossaryGuid>",
                    relationGuid = "<relationGuid>",
                },
                antonyms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                createTime = 123.45F,
                createdBy = "<createdBy>",
                updateTime = 123.45F,
                updatedBy = "<updatedBy>",
                status = "Draft",
                resources = new object[]
            {
new
{
displayName = "<displayName>",
url = "<url>",
}
            },
                contacts = new
                {
                    key = new object[]
            {
new
{
id = "<id>",
info = "<info>",
}
            },
                },
                attributes = new
                {
                    key = new
                    {
                        key = new object(),
                    },
                },
                assignedEntities = new object[]
            {
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
            },
                categories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
relationGuid = "<relationGuid>",
status = "DRAFT",
}
            },
                classifies = new object[]
            {
null
            },
                examples = new object[]
            {
"<examples>"
            },
                isA = new object[]
            {
null
            },
                preferredTerms = new object[]
            {
null
            },
                preferredToTerms = new object[]
            {
null
            },
                replacedBy = new object[]
            {
null
            },
                replacementTerms = new object[]
            {
null
            },
                seeAlso = new object[]
            {
null
            },
                synonyms = new object[]
            {
null
            },
                translatedTerms = new object[]
            {
null
            },
                translationTerms = new object[]
            {
null
            },
                usage = "<usage>",
                validValues = new object[]
            {
null
            },
                validValuesFor = new object[]
            {
null
            },
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = client.UpdateGlossaryTerm("<termGuid>", content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("abbreviation").ToString());
            Console.WriteLine(result.GetProperty("templateName")[0].ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("examples")[0].ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateGlossaryTerm_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                abbreviation = "<abbreviation>",
                templateName = new object[]
            {
new object()
            },
                anchor = new
                {
                    displayText = "<displayText>",
                    glossaryGuid = "<glossaryGuid>",
                    relationGuid = "<relationGuid>",
                },
                antonyms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                createTime = 123.45F,
                createdBy = "<createdBy>",
                updateTime = 123.45F,
                updatedBy = "<updatedBy>",
                status = "Draft",
                resources = new object[]
            {
new
{
displayName = "<displayName>",
url = "<url>",
}
            },
                contacts = new
                {
                    key = new object[]
            {
new
{
id = "<id>",
info = "<info>",
}
            },
                },
                attributes = new
                {
                    key = new
                    {
                        key = new object(),
                    },
                },
                assignedEntities = new object[]
            {
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
            },
                categories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
relationGuid = "<relationGuid>",
status = "DRAFT",
}
            },
                classifies = new object[]
            {
null
            },
                examples = new object[]
            {
"<examples>"
            },
                isA = new object[]
            {
null
            },
                preferredTerms = new object[]
            {
null
            },
                preferredToTerms = new object[]
            {
null
            },
                replacedBy = new object[]
            {
null
            },
                replacementTerms = new object[]
            {
null
            },
                seeAlso = new object[]
            {
null
            },
                synonyms = new object[]
            {
null
            },
                translatedTerms = new object[]
            {
null
            },
                translationTerms = new object[]
            {
null
            },
                usage = "<usage>",
                validValues = new object[]
            {
null
            },
                validValuesFor = new object[]
            {
null
            },
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = await client.UpdateGlossaryTermAsync("<termGuid>", content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("abbreviation").ToString());
            Console.WriteLine(result.GetProperty("templateName")[0].ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("examples")[0].ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteGlossaryTerm_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.DeleteGlossaryTerm("<termGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteGlossaryTerm_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.DeleteGlossaryTermAsync("<termGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteGlossaryTerm_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.DeleteGlossaryTerm("<termGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteGlossaryTerm_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.DeleteGlossaryTermAsync("<termGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_PartialUpdateGlossaryTerm_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = client.PartialUpdateGlossaryTerm("<termGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_PartialUpdateGlossaryTerm_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = await client.PartialUpdateGlossaryTermAsync("<termGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_PartialUpdateGlossaryTerm_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = client.PartialUpdateGlossaryTerm("<termGuid>", content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("abbreviation").ToString());
            Console.WriteLine(result.GetProperty("templateName")[0].ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("examples")[0].ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_PartialUpdateGlossaryTerm_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = await client.PartialUpdateGlossaryTermAsync("<termGuid>", content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("abbreviation").ToString());
            Console.WriteLine(result.GetProperty("templateName")[0].ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result.GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("examples")[0].ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateGlossaryTerms_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new object()
            });
            Response response = client.CreateGlossaryTerms(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateGlossaryTerms_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new object()
            });
            Response response = await client.CreateGlossaryTermsAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateGlossaryTerms_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
abbreviation = "<abbreviation>",
templateName = new object[]
{
new object()
},
anchor = new
{
displayText = "<displayText>",
glossaryGuid = "<glossaryGuid>",
relationGuid = "<relationGuid>",
},
antonyms = new object[]
{
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
},
createTime = 123.45F,
createdBy = "<createdBy>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
status = "Draft",
resources = new object[]
{
new
{
displayName = "<displayName>",
url = "<url>",
}
},
contacts = new
{
key = new object[]
{
new
{
id = "<id>",
info = "<info>",
}
},
},
attributes = new
{
key = new
{
key = new object(),
},
},
assignedEntities = new object[]
{
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
},
categories = new object[]
{
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
relationGuid = "<relationGuid>",
status = "DRAFT",
}
},
classifies = new object[]
{
null
},
examples = new object[]
{
"<examples>"
},
isA = new object[]
{
null
},
preferredTerms = new object[]
{
null
},
preferredToTerms = new object[]
{
null
},
replacedBy = new object[]
{
null
},
replacementTerms = new object[]
{
null
},
seeAlso = new object[]
{
null
},
synonyms = new object[]
{
null
},
translatedTerms = new object[]
{
null
},
translationTerms = new object[]
{
null
},
usage = "<usage>",
validValues = new object[]
{
null
},
validValuesFor = new object[]
{
null
},
classifications = new object[]
{
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
},
longDescription = "<longDescription>",
name = "<name>",
qualifiedName = "<qualifiedName>",
shortDescription = "<shortDescription>",
lastModifiedTS = "<lastModifiedTS>",
guid = "<guid>",
}
            });
            Response response = client.CreateGlossaryTerms(content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("abbreviation").ToString());
            Console.WriteLine(result[0].GetProperty("templateName")[0].ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("createTime").ToString());
            Console.WriteLine(result[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result[0].GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("examples")[0].ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("usage").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateGlossaryTerms_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
abbreviation = "<abbreviation>",
templateName = new object[]
{
new object()
},
anchor = new
{
displayText = "<displayText>",
glossaryGuid = "<glossaryGuid>",
relationGuid = "<relationGuid>",
},
antonyms = new object[]
{
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
},
createTime = 123.45F,
createdBy = "<createdBy>",
updateTime = 123.45F,
updatedBy = "<updatedBy>",
status = "Draft",
resources = new object[]
{
new
{
displayName = "<displayName>",
url = "<url>",
}
},
contacts = new
{
key = new object[]
{
new
{
id = "<id>",
info = "<info>",
}
},
},
attributes = new
{
key = new
{
key = new object(),
},
},
assignedEntities = new object[]
{
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
},
categories = new object[]
{
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
relationGuid = "<relationGuid>",
status = "DRAFT",
}
},
classifies = new object[]
{
null
},
examples = new object[]
{
"<examples>"
},
isA = new object[]
{
null
},
preferredTerms = new object[]
{
null
},
preferredToTerms = new object[]
{
null
},
replacedBy = new object[]
{
null
},
replacementTerms = new object[]
{
null
},
seeAlso = new object[]
{
null
},
synonyms = new object[]
{
null
},
translatedTerms = new object[]
{
null
},
translationTerms = new object[]
{
null
},
usage = "<usage>",
validValues = new object[]
{
null
},
validValuesFor = new object[]
{
null
},
classifications = new object[]
{
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
},
longDescription = "<longDescription>",
name = "<name>",
qualifiedName = "<qualifiedName>",
shortDescription = "<shortDescription>",
lastModifiedTS = "<lastModifiedTS>",
guid = "<guid>",
}
            });
            Response response = await client.CreateGlossaryTermsAsync(content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("abbreviation").ToString());
            Console.WriteLine(result[0].GetProperty("templateName")[0].ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("createTime").ToString());
            Console.WriteLine(result[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result[0].GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("examples")[0].ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("usage").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEntitiesAssignedWithTerm_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetEntitiesAssignedWithTerm("<termGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEntitiesAssignedWithTerm_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetEntitiesAssignedWithTermAsync("<termGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEntitiesAssignedWithTerm_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetEntitiesAssignedWithTerm("<termGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
            Console.WriteLine(result[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEntitiesAssignedWithTerm_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetEntitiesAssignedWithTermAsync("<termGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
            Console.WriteLine(result[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AssignTermToEntities_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new object()
            });
            Response response = client.AssignTermToEntities("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AssignTermToEntities_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new object()
            });
            Response response = await client.AssignTermToEntitiesAsync("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AssignTermToEntities_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
            });
            Response response = client.AssignTermToEntities("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AssignTermToEntities_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
            });
            Response response = await client.AssignTermToEntitiesAsync("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_RemoveTermAssignmentFromEntities_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new object()
            });
            Response response = client.RemoveTermAssignmentFromEntities("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_RemoveTermAssignmentFromEntities_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new object()
            });
            Response response = await client.RemoveTermAssignmentFromEntitiesAsync("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_RemoveTermAssignmentFromEntities_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
            });
            Response response = client.RemoveTermAssignmentFromEntities("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_RemoveTermAssignmentFromEntities_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
            });
            Response response = await client.RemoveTermAssignmentFromEntitiesAsync("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteTermAssignmentFromEntities_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new object()
            });
            Response response = client.DeleteTermAssignmentFromEntities("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteTermAssignmentFromEntities_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new object()
            });
            Response response = await client.DeleteTermAssignmentFromEntitiesAsync("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteTermAssignmentFromEntities_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
            });
            Response response = client.DeleteTermAssignmentFromEntities("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteTermAssignmentFromEntities_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
displayText = "<displayText>",
entityStatus = "ACTIVE",
relationshipType = "<relationshipType>",
relationshipAttributes = new
{
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
},
relationshipGuid = "<relationshipGuid>",
relationshipStatus = "ACTIVE",
guid = "<guid>",
typeName = "<typeName>",
uniqueAttributes = new
{
key = new object(),
},
}
            });
            Response response = await client.DeleteTermAssignmentFromEntitiesAsync("<termGuid>", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRelatedTerms_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetRelatedTerms("<termGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRelatedTerms_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetRelatedTermsAsync("<termGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetRelatedTerms_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetRelatedTerms("<termGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("termGuid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetRelatedTerms_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetRelatedTermsAsync("<termGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("<key>")[0].GetProperty("termGuid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossary_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossary("<glossaryGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossary_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryAsync("<glossaryGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossary_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossary("<glossaryGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("language").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossary_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryAsync("<glossaryGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("language").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateGlossary_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.UpdateGlossary("<glossaryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateGlossary_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.UpdateGlossaryAsync("<glossaryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateGlossary_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                categories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
parentCategoryGuid = "<parentCategoryGuid>",
relationGuid = "<relationGuid>",
}
            },
                language = "<language>",
                terms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                usage = "<usage>",
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = client.UpdateGlossary("<glossaryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("language").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateGlossary_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                categories = new object[]
            {
new
{
categoryGuid = "<categoryGuid>",
description = "<description>",
displayText = "<displayText>",
parentCategoryGuid = "<parentCategoryGuid>",
relationGuid = "<relationGuid>",
}
            },
                language = "<language>",
                terms = new object[]
            {
new
{
description = "<description>",
displayText = "<displayText>",
expression = "<expression>",
relationGuid = "<relationGuid>",
source = "<source>",
status = "DRAFT",
steward = "<steward>",
termGuid = "<termGuid>",
}
            },
                usage = "<usage>",
                classifications = new object[]
            {
new
{
entityGuid = "<entityGuid>",
entityStatus = "ACTIVE",
removePropagationsOnEntityDelete = true,
validityPeriods = new object[]
{
new
{
endTime = "<endTime>",
startTime = "<startTime>",
timeZone = "<timeZone>",
}
},
source = "<source>",
sourceDetails = new
{
key = new object(),
},
attributes = new
{
key = new object(),
},
typeName = "<typeName>",
lastModifiedTS = "<lastModifiedTS>",
}
            },
                longDescription = "<longDescription>",
                name = "<name>",
                qualifiedName = "<qualifiedName>",
                shortDescription = "<shortDescription>",
                lastModifiedTS = "<lastModifiedTS>",
                guid = "<guid>",
            });
            Response response = await client.UpdateGlossaryAsync("<glossaryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("language").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteGlossary_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.DeleteGlossary("<glossaryGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteGlossary_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.DeleteGlossaryAsync("<glossaryGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteGlossary_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.DeleteGlossary("<glossaryGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteGlossary_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.DeleteGlossaryAsync("<glossaryGuid>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryCategories_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryCategories("<glossaryGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryCategories_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryCategoriesAsync("<glossaryGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryCategories_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryCategories("<glossaryGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryCategories_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryCategoriesAsync("<glossaryGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryCategoriesHeaders_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryCategoriesHeaders("<glossaryGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryCategoriesHeaders_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryCategoriesHeadersAsync("<glossaryGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryCategoriesHeaders_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryCategoriesHeaders("<glossaryGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("relationGuid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryCategoriesHeaders_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryCategoriesHeadersAsync("<glossaryGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("relationGuid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDetailedGlossary_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetDetailedGlossary("<glossaryGuid>", null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDetailedGlossary_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetDetailedGlossaryAsync("<glossaryGuid>", null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDetailedGlossary_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetDetailedGlossary("<glossaryGuid>", true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("abbreviation").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("templateName")[0].ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("examples")[0].ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("language").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDetailedGlossary_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetDetailedGlossaryAsync("<glossaryGuid>", true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("childrenCategories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("childrenCategories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("childrenCategories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("childrenCategories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("childrenCategories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("parentCategory").GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("parentCategory").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("parentCategory").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("parentCategory").GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("parentCategory").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("categoryInfo").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("abbreviation").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("templateName")[0].ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("updateTime").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("examples")[0].ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("termInfo").GetProperty("<key>").GetProperty("guid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("language").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_PartialUpdateGlossary_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = client.PartialUpdateGlossary("<glossaryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_PartialUpdateGlossary_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = await client.PartialUpdateGlossaryAsync("<glossaryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_PartialUpdateGlossary_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = client.PartialUpdateGlossary("<glossaryGuid>", content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("language").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_PartialUpdateGlossary_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new
            {
                key = "<partialUpdates>",
            });
            Response response = await client.PartialUpdateGlossaryAsync("<glossaryGuid>", content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("parentCategoryGuid").ToString());
            Console.WriteLine(result.GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("language").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result.GetProperty("terms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result.GetProperty("usage").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result.GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("longDescription").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("qualifiedName").ToString());
            Console.WriteLine(result.GetProperty("shortDescription").ToString());
            Console.WriteLine(result.GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result.GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryTerms_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryTerms("<glossaryGuid>", null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryTerms_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryTermsAsync("<glossaryGuid>", null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryTerms_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryTerms("<glossaryGuid>", true, 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("abbreviation").ToString());
            Console.WriteLine(result[0].GetProperty("templateName")[0].ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("createTime").ToString());
            Console.WriteLine(result[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result[0].GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("examples")[0].ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("usage").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryTerms_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryTermsAsync("<glossaryGuid>", true, 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("abbreviation").ToString());
            Console.WriteLine(result[0].GetProperty("templateName")[0].ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("createTime").ToString());
            Console.WriteLine(result[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result[0].GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("examples")[0].ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("usage").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryTermHeaders_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryTermHeaders("<glossaryGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryTermHeaders_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryTermHeadersAsync("<glossaryGuid>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGlossaryTermHeaders_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetGlossaryTermHeaders("<glossaryGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("termGuid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGlossaryTermHeaders_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetGlossaryTermHeadersAsync("<glossaryGuid>", 1234, 1234, "<sort>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("termGuid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetImportCsvOperationStatus_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetImportCsvOperationStatus("<operationGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetImportCsvOperationStatus_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetImportCsvOperationStatusAsync("<operationGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetImportCsvOperationStatus_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetImportCsvOperationStatus("<operationGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("importedTerms").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("totalTermsDetected").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorMessage").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetImportCsvOperationStatus_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetImportCsvOperationStatusAsync("<operationGuid>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("importedTerms").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("totalTermsDetected").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorMessage").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ExportGlossaryTermsAsCsv_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"<termGuids>"
            });
            Response response = client.ExportGlossaryTermsAsCsv("<glossaryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ExportGlossaryTermsAsCsv_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"<termGuids>"
            });
            Response response = await client.ExportGlossaryTermsAsCsvAsync("<glossaryGuid>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ExportGlossaryTermsAsCsv_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"<termGuids>"
            });
            Response response = client.ExportGlossaryTermsAsCsv("<glossaryGuid>", content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ExportGlossaryTermsAsCsv_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"<termGuids>"
            });
            Response response = await client.ExportGlossaryTermsAsCsvAsync("<glossaryGuid>", content, includeTermHierarchy: true);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTermsByGlossaryName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetTermsByGlossaryName("<glossaryName>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTermsByGlossaryName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetTermsByGlossaryNameAsync("<glossaryName>", null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTermsByGlossaryName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = client.GetTermsByGlossaryName("<glossaryName>", 1234, 1234, true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("abbreviation").ToString());
            Console.WriteLine(result[0].GetProperty("templateName")[0].ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("createTime").ToString());
            Console.WriteLine(result[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result[0].GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("examples")[0].ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("usage").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTermsByGlossaryName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            Response response = await client.GetTermsByGlossaryNameAsync("<glossaryName>", 1234, 1234, true, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].GetProperty("abbreviation").ToString());
            Console.WriteLine(result[0].GetProperty("templateName")[0].ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("glossaryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("anchor").GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("antonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("createTime").ToString());
            Console.WriteLine(result[0].GetProperty("createdBy").ToString());
            Console.WriteLine(result[0].GetProperty("updateTime").ToString());
            Console.WriteLine(result[0].GetProperty("updatedBy").ToString());
            Console.WriteLine(result[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("displayName").ToString());
            Console.WriteLine(result[0].GetProperty("resources")[0].GetProperty("url").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("id").ToString());
            Console.WriteLine(result[0].GetProperty("contacts").GetProperty("<key>")[0].GetProperty("info").ToString());
            Console.WriteLine(result[0].GetProperty("attributes").GetProperty("<key>").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipType").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipAttributes").GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipGuid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("relationshipStatus").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("guid").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("assignedEntities")[0].GetProperty("uniqueAttributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("categoryGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("categories")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("classifies")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("examples")[0].ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("isA")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("preferredToTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacedBy")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("replacementTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("seeAlso")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("synonyms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translatedTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("translationTerms")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("usage").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValues")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("description").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("displayText").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("expression").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("relationGuid").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("status").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("steward").ToString());
            Console.WriteLine(result[0].GetProperty("validValuesFor")[0].GetProperty("termGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityGuid").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("entityStatus").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("removePropagationsOnEntityDelete").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("endTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("startTime").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("validityPeriods")[0].GetProperty("timeZone").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("source").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("sourceDetails").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("attributes").GetProperty("<key>").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("typeName").ToString());
            Console.WriteLine(result[0].GetProperty("classifications")[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("longDescription").ToString());
            Console.WriteLine(result[0].GetProperty("name").ToString());
            Console.WriteLine(result[0].GetProperty("qualifiedName").ToString());
            Console.WriteLine(result[0].GetProperty("shortDescription").ToString());
            Console.WriteLine(result[0].GetProperty("lastModifiedTS").ToString());
            Console.WriteLine(result[0].GetProperty("guid").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ImportGlossaryTermsViaCsv_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(File.OpenRead("<filePath>"));
            Operation<BinaryData> operation = client.ImportGlossaryTermsViaCsv(WaitUntil.Completed, "<glossaryGuid>", content, "multipart/form-data");
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ImportGlossaryTermsViaCsv_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(File.OpenRead("<filePath>"));
            Operation<BinaryData> operation = await client.ImportGlossaryTermsViaCsvAsync(WaitUntil.Completed, "<glossaryGuid>", content, "multipart/form-data");
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ImportGlossaryTermsViaCsv_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(File.OpenRead("<filePath>"));
            Operation<BinaryData> operation = client.ImportGlossaryTermsViaCsv(WaitUntil.Completed, "<glossaryGuid>", content, "multipart/form-data", includeTermHierarchy: true);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("importedTerms").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("totalTermsDetected").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorMessage").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ImportGlossaryTermsViaCsv_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(File.OpenRead("<filePath>"));
            Operation<BinaryData> operation = await client.ImportGlossaryTermsViaCsvAsync(WaitUntil.Completed, "<glossaryGuid>", content, "multipart/form-data", includeTermHierarchy: true);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("importedTerms").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("totalTermsDetected").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorMessage").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ImportGlossaryTermsViaCsvByGlossaryName_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(File.OpenRead("<filePath>"));
            Operation<BinaryData> operation = client.ImportGlossaryTermsViaCsvByGlossaryName(WaitUntil.Completed, "<glossaryName>", content, "multipart/form-data");
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ImportGlossaryTermsViaCsvByGlossaryName_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(File.OpenRead("<filePath>"));
            Operation<BinaryData> operation = await client.ImportGlossaryTermsViaCsvByGlossaryNameAsync(WaitUntil.Completed, "<glossaryName>", content, "multipart/form-data");
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ImportGlossaryTermsViaCsvByGlossaryName_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(File.OpenRead("<filePath>"));
            Operation<BinaryData> operation = client.ImportGlossaryTermsViaCsvByGlossaryName(WaitUntil.Completed, "<glossaryName>", content, "multipart/form-data", includeTermHierarchy: true);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("importedTerms").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("totalTermsDetected").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorMessage").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ImportGlossaryTermsViaCsvByGlossaryName_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewGlossaries client = new PurviewCatalogClient(endpoint, credential).GetPurviewGlossariesClient();

            using RequestContent content = RequestContent.Create(File.OpenRead("<filePath>"));
            Operation<BinaryData> operation = await client.ImportGlossaryTermsViaCsvByGlossaryNameAsync(WaitUntil.Completed, "<glossaryName>", content, "multipart/form-data", includeTermHierarchy: true);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("importedTerms").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("totalTermsDetected").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("errorMessage").ToString());
        }
    }
}
