// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Analytics.Purview.Catalog
{
    // Data plane generated sub-client.
    /// <summary> The PurviewLineages sub-client. </summary>
    public partial class PurviewLineages
    {
        private static readonly string[] AuthorizationScopes = new string[] { "https://purview.azure.net/.default" };
        private readonly TokenCredential _tokenCredential;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public virtual HttpPipeline Pipeline => _pipeline;

        /// <summary> Initializes a new instance of PurviewLineages for mocking. </summary>
        protected PurviewLineages()
        {
        }

        /// <summary> Initializes a new instance of PurviewLineages. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="tokenCredential"> The token credential to copy. </param>
        /// <param name="endpoint"> The catalog endpoint of your Purview account. Example: https://{accountName}.purview.azure.com. </param>
        /// <param name="apiVersion"> Api Version. </param>
        internal PurviewLineages(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, TokenCredential tokenCredential, Uri endpoint, string apiVersion)
        {
            ClientDiagnostics = clientDiagnostics;
            _pipeline = pipeline;
            _tokenCredential = tokenCredential;
            _endpoint = endpoint;
            _apiVersion = apiVersion;
        }

        /// <summary>
        /// [Protocol Method] Get lineage info of the entity specified by GUID.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "BOTH" | "INPUT" | "OUTPUT". </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="width"> The number of max expanding width in lineage. </param>
        /// <param name="includeParent"> True to include the parent chain in the response. </param>
        /// <param name="getDerivedLineage"> True to include derived lineage in the response. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/PurviewLineages.xml" path="doc/members/member[@name='GetLineageGraphAsync(string,string,int?,int?,bool?,bool?,RequestContext)']/*" />
        public virtual async Task<Response> GetLineageGraphAsync(string guid, string direction, int? depth, int? width, bool? includeParent, bool? getDerivedLineage, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("PurviewLineages.GetLineageGraph");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLineageGraphRequest(guid, direction, depth, width, includeParent, getDerivedLineage, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Get lineage info of the entity specified by GUID.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "BOTH" | "INPUT" | "OUTPUT". </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="width"> The number of max expanding width in lineage. </param>
        /// <param name="includeParent"> True to include the parent chain in the response. </param>
        /// <param name="getDerivedLineage"> True to include derived lineage in the response. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/PurviewLineages.xml" path="doc/members/member[@name='GetLineageGraph(string,string,int?,int?,bool?,bool?,RequestContext)']/*" />
        public virtual Response GetLineageGraph(string guid, string direction, int? depth, int? width, bool? includeParent, bool? getDerivedLineage, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("PurviewLineages.GetLineageGraph");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLineageGraphRequest(guid, direction, depth, width, includeParent, getDerivedLineage, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Return immediate next page lineage info about entity with pagination
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "BOTH" | "INPUT" | "OUTPUT". </param>
        /// <param name="getDerivedLineage"> True to include derived lineage in the response. </param>
        /// <param name="offset"> The offset for pagination purpose. </param>
        /// <param name="limit"> The page size - by default there is no paging. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/PurviewLineages.xml" path="doc/members/member[@name='NextPageLineageAsync(string,string,bool?,int?,int?,RequestContext)']/*" />
        public virtual async Task<Response> NextPageLineageAsync(string guid, string direction, bool? getDerivedLineage, int? offset, int? limit, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("PurviewLineages.NextPageLineage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateNextPageLineageRequest(guid, direction, getDerivedLineage, offset, limit, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Return immediate next page lineage info about entity with pagination
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "BOTH" | "INPUT" | "OUTPUT". </param>
        /// <param name="getDerivedLineage"> True to include derived lineage in the response. </param>
        /// <param name="offset"> The offset for pagination purpose. </param>
        /// <param name="limit"> The page size - by default there is no paging. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/PurviewLineages.xml" path="doc/members/member[@name='NextPageLineage(string,string,bool?,int?,int?,RequestContext)']/*" />
        public virtual Response NextPageLineage(string guid, string direction, bool? getDerivedLineage, int? offset, int? limit, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("PurviewLineages.NextPageLineage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateNextPageLineageRequest(guid, direction, getDerivedLineage, offset, limit, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Returns lineage info about entity.
        ///
        /// In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the following format
        ///
        /// attr:[attrName]=[attrValue]
        ///
        /// NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "BOTH" | "INPUT" | "OUTPUT". </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="width"> The number of max expanding width in lineage. </param>
        /// <param name="includeParent"> True to include the parent chain in the response. </param>
        /// <param name="getDerivedLineage"> True to include derived lineage in the response. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="typeName"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="typeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/PurviewLineages.xml" path="doc/members/member[@name='GetLineageByUniqueAttributeAsync(string,string,int?,int?,bool?,bool?,RequestContext)']/*" />
        public virtual async Task<Response> GetLineageByUniqueAttributeAsync(string typeName, string direction, int? depth, int? width, bool? includeParent, bool? getDerivedLineage, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(typeName, nameof(typeName));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("PurviewLineages.GetLineageByUniqueAttribute");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLineageByUniqueAttributeRequest(typeName, direction, depth, width, includeParent, getDerivedLineage, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Returns lineage info about entity.
        ///
        /// In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the following format
        ///
        /// attr:[attrName]=[attrValue]
        ///
        /// NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "BOTH" | "INPUT" | "OUTPUT". </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="width"> The number of max expanding width in lineage. </param>
        /// <param name="includeParent"> True to include the parent chain in the response. </param>
        /// <param name="getDerivedLineage"> True to include derived lineage in the response. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="typeName"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="typeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/PurviewLineages.xml" path="doc/members/member[@name='GetLineageByUniqueAttribute(string,string,int?,int?,bool?,bool?,RequestContext)']/*" />
        public virtual Response GetLineageByUniqueAttribute(string typeName, string direction, int? depth, int? width, bool? includeParent, bool? getDerivedLineage, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(typeName, nameof(typeName));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("PurviewLineages.GetLineageByUniqueAttribute");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLineageByUniqueAttributeRequest(typeName, direction, depth, width, includeParent, getDerivedLineage, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        internal HttpMessage CreateGetLineageGraphRequest(string guid, string direction, int? depth, int? width, bool? includeParent, bool? getDerivedLineage, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/catalog/api", false);
            uri.AppendPath("/atlas/v2/lineage/", false);
            uri.AppendPath(guid, true);
            uri.AppendQuery("direction", direction, true);
            if (depth != null)
            {
                uri.AppendQuery("depth", depth.Value, true);
            }
            if (width != null)
            {
                uri.AppendQuery("width", width.Value, true);
            }
            if (includeParent != null)
            {
                uri.AppendQuery("includeParent", includeParent.Value, true);
            }
            if (getDerivedLineage != null)
            {
                uri.AppendQuery("getDerivedLineage", getDerivedLineage.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateNextPageLineageRequest(string guid, string direction, bool? getDerivedLineage, int? offset, int? limit, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/catalog/api", false);
            uri.AppendPath("/lineage/", false);
            uri.AppendPath(guid, true);
            uri.AppendPath("/next/", false);
            uri.AppendQuery("direction", direction, true);
            if (getDerivedLineage != null)
            {
                uri.AppendQuery("getDerivedLineage", getDerivedLineage.Value, true);
            }
            if (offset != null)
            {
                uri.AppendQuery("offset", offset.Value, true);
            }
            if (limit != null)
            {
                uri.AppendQuery("limit", limit.Value, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetLineageByUniqueAttributeRequest(string typeName, string direction, int? depth, int? width, bool? includeParent, bool? getDerivedLineage, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/catalog/api", false);
            uri.AppendPath("/atlas/v2/lineage/uniqueAttribute/type/", false);
            uri.AppendPath(typeName, true);
            uri.AppendQuery("direction", direction, true);
            if (depth != null)
            {
                uri.AppendQuery("depth", depth.Value, true);
            }
            if (width != null)
            {
                uri.AppendQuery("width", width.Value, true);
            }
            if (includeParent != null)
            {
                uri.AppendQuery("includeParent", includeParent.Value, true);
            }
            if (getDerivedLineage != null)
            {
                uri.AppendQuery("getDerivedLineage", getDerivedLineage.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        private static ResponseClassifier _responseClassifier200;
        private static ResponseClassifier ResponseClassifier200 => _responseClassifier200 ??= new StatusCodeClassifier(stackalloc ushort[] { 200 });
    }
}
