// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Analytics.Purview.Catalog;
using Azure.Core.Extensions;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="PurviewCatalogClient"/> to client builder. </summary>
    public static partial class AnalyticsPurviewCatalogClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="PurviewCatalogClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The catalog endpoint of your Purview account. Example: https://{accountName}.purview.azure.com. </param>
        public static IAzureClientBuilder<PurviewCatalogClient, PurviewCatalogClientOptions> AddPurviewCatalogClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<PurviewCatalogClient, PurviewCatalogClientOptions>((options, cred) => new PurviewCatalogClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="PurviewCatalogClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<PurviewCatalogClient, PurviewCatalogClientOptions> AddPurviewCatalogClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<PurviewCatalogClient, PurviewCatalogClientOptions>(configuration);
        }
    }
}
