// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Administration.Samples
{
    public partial class Samples_PurviewMetadataRolesClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetMetadataRoles_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewMetadataRolesClient client = new PurviewMetadataRolesClient(endpoint, credential);

            foreach (BinaryData item in client.GetMetadataRoles(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetMetadataRoles_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewMetadataRolesClient client = new PurviewMetadataRolesClient(endpoint, credential);

            await foreach (BinaryData item in client.GetMetadataRolesAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetMetadataRoles_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewMetadataRolesClient client = new PurviewMetadataRolesClient(endpoint, credential);

            foreach (BinaryData item in client.GetMetadataRoles(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("provisioningState").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("roleType").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("cnfCondition")[0][0].GetProperty("attributeName").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("cnfCondition")[0][0].GetProperty("attributeValueIncludes").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("cnfCondition")[0][0].GetProperty("attributeValueIncludedIn")[0].ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("cnfCondition")[0][0].GetProperty("attributeValueExcludes").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("cnfCondition")[0][0].GetProperty("attributeValueExcludedIn")[0].ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("dnfCondition")[0][0].GetProperty("attributeName").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("dnfCondition")[0][0].GetProperty("attributeValueIncludes").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("dnfCondition")[0][0].GetProperty("attributeValueIncludedIn")[0].ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("dnfCondition")[0][0].GetProperty("attributeValueExcludes").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("dnfCondition")[0][0].GetProperty("attributeValueExcludedIn")[0].ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("version").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetMetadataRoles_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            PurviewMetadataRolesClient client = new PurviewMetadataRolesClient(endpoint, credential);

            await foreach (BinaryData item in client.GetMetadataRolesAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("provisioningState").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("roleType").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("cnfCondition")[0][0].GetProperty("attributeName").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("cnfCondition")[0][0].GetProperty("attributeValueIncludes").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("cnfCondition")[0][0].GetProperty("attributeValueIncludedIn")[0].ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("cnfCondition")[0][0].GetProperty("attributeValueExcludes").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("cnfCondition")[0][0].GetProperty("attributeValueExcludedIn")[0].ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("dnfCondition")[0][0].GetProperty("attributeName").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("dnfCondition")[0][0].GetProperty("attributeValueIncludes").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("dnfCondition")[0][0].GetProperty("attributeValueIncludedIn")[0].ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("dnfCondition")[0][0].GetProperty("attributeValueExcludes").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("dnfCondition")[0][0].GetProperty("attributeValueExcludedIn")[0].ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("version").ToString());
            }
        }
    }
}
