// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Runtime.CompilerServices;
using System.Threading;
using Azure;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Analytics.Purview.Administration
{
    /// <summary> The PurviewMetadataRoles service client. </summary>
    [CodeGenClient("PurviewMetadataRolesClient")]
    [CodeGenSuppress("PurviewMetadataRolesClient", new Type[] { typeof(Uri), typeof(TokenCredential), typeof(PurviewAccountClientOptions)})]
    [CodeGenSuppress("PurviewMetadataRolesClient", new Type[] { typeof(Uri), typeof(TokenCredential)})]
    public partial class PurviewMetadataRolesClient
    {
        /// <summary> Initializes a new instance of PurviewMetadataRolesClient. </summary>
        /// <param name="endpoint"> The endpoint of your Purview account. Example: https://{accountName}.purview.azure.com. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public PurviewMetadataRolesClient(Uri endpoint, TokenCredential credential) : this(endpoint, credential, new PurviewMetadataClientOptions())
        {
        }

        /// <summary> Initializes a new instance of PurviewMetadataRolesClient. </summary>
        /// <param name="endpoint"> The endpoint of your Purview account. Example: https://{accountName}.purview.azure.com. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public PurviewMetadataRolesClient(Uri endpoint, TokenCredential credential, PurviewMetadataClientOptions options)
        {
            if (endpoint == null)
            {
                throw new ArgumentNullException(nameof(endpoint));
            }
            if (credential == null)
            {
                throw new ArgumentNullException(nameof(credential));
            }

            options ??= new PurviewMetadataClientOptions();

            ClientDiagnostics = new ClientDiagnostics(options, true);
            _tokenCredential = credential;
            _pipeline = HttpPipelineBuilder.Build(options, Array.Empty<HttpPipelinePolicy>(), new HttpPipelinePolicy[] { new BearerTokenAuthenticationPolicy(_tokenCredential, AuthorizationScopes) }, new ResponseClassifier());
            _endpoint = endpoint;
        }
    }
}
