// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// TemplateSpecVersion.
/// </summary>
public partial class TemplateSpecVersion : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The location of the Template Spec Version. It must match the location
    /// of the parent Template Spec.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Template Spec version description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// An array of linked template artifacts.
    /// </summary>
    public BicepList<LinkedTemplateArtifact> LinkedTemplates 
    {
        get { Initialize(); return _linkedTemplates!; }
        set { Initialize(); _linkedTemplates!.Assign(value); }
    }
    private BicepList<LinkedTemplateArtifact>? _linkedTemplates;

    /// <summary>
    /// The main Azure Resource Manager template content.
    /// To assign an object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> MainTemplate 
    {
        get { Initialize(); return _mainTemplate!; }
        set { Initialize(); _mainTemplate!.Assign(value); }
    }
    private BicepValue<BinaryData>? _mainTemplate;

    /// <summary>
    /// The version metadata. Metadata is an open-ended object and is typically
    /// a collection of key-value pairs.                          To assign an
    /// object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> Metadata 
    {
        get { Initialize(); return _metadata!; }
        set { Initialize(); _metadata!.Assign(value); }
    }
    private BicepValue<BinaryData>? _metadata;

    /// <summary>
    /// Resource tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The Azure Resource Manager template UI definition content.
    /// To assign an object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> UiFormDefinition 
    {
        get { Initialize(); return _uiFormDefinition!; }
        set { Initialize(); _uiFormDefinition!.Assign(value); }
    }
    private BicepValue<BinaryData>? _uiFormDefinition;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent TemplateSpec.
    /// </summary>
    public TemplateSpec? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<TemplateSpec>? _parent;

    /// <summary>
    /// Creates a new TemplateSpecVersion.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the TemplateSpecVersion resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the TemplateSpecVersion.</param>
    public TemplateSpecVersion(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Resources/templateSpecs/versions", resourceVersion ?? "2022-02-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of TemplateSpecVersion.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _description = DefineProperty<string>("Description", ["properties", "description"]);
        _linkedTemplates = DefineListProperty<LinkedTemplateArtifact>("LinkedTemplates", ["properties", "linkedTemplates"]);
        _mainTemplate = DefineProperty<BinaryData>("MainTemplate", ["properties", "mainTemplate"]);
        _metadata = DefineProperty<BinaryData>("Metadata", ["properties", "metadata"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _uiFormDefinition = DefineProperty<BinaryData>("UiFormDefinition", ["properties", "uiFormDefinition"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<TemplateSpec>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported TemplateSpecVersion resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2022-02-01.
        /// </summary>
        public static readonly string V2022_02_01 = "2022-02-01";

        /// <summary>
        /// 2021-05-01.
        /// </summary>
        public static readonly string V2021_05_01 = "2021-05-01";
    }

    /// <summary>
    /// Creates a reference to an existing TemplateSpecVersion.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the TemplateSpecVersion resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the TemplateSpecVersion.</param>
    /// <returns>The existing TemplateSpecVersion resource.</returns>
    public static TemplateSpecVersion FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
