// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Subscription.
/// </summary>
public partial class Subscription : ProvisionableResource
{
    /// <summary>
    /// The authorization source of the request. Valid values are one or more
    /// combinations of Legacy, RoleBased, Bypassed, Direct and Management.
    /// For example, &apos;Legacy, RoleBased&apos;.
    /// </summary>
    public BicepValue<string> AuthorizationSource 
    {
        get { Initialize(); return _authorizationSource!; }
    }
    private BicepValue<string>? _authorizationSource;

    /// <summary>
    /// The subscription display name.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// The ARM resource identifier.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// An array containing the tenants managing the subscription.
    /// </summary>
    public BicepList<ManagedByTenant> ManagedByTenants 
    {
        get { Initialize(); return _managedByTenants!; }
    }
    private BicepList<ManagedByTenant>? _managedByTenants;

    /// <summary>
    /// The subscription state. Possible values are Enabled, Warned, PastDue,
    /// Disabled, and Deleted.
    /// </summary>
    public BicepValue<SubscriptionState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<SubscriptionState>? _state;

    /// <summary>
    /// The subscription ID.
    /// </summary>
    public BicepValue<string> SubscriptionId 
    {
        get { Initialize(); return _subscriptionId!; }
    }
    private BicepValue<string>? _subscriptionId;

    /// <summary>
    /// The subscription policies.
    /// </summary>
    public SubscriptionPolicies SubscriptionPolicies 
    {
        get { Initialize(); return _subscriptionPolicies!; }
    }
    private SubscriptionPolicies? _subscriptionPolicies;

    /// <summary>
    /// The tags attached to the subscription.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The subscription tenant ID.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Creates a new Subscription.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the Subscription resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the Subscription.</param>
    public Subscription(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Resources/subscriptions", resourceVersion ?? "2019-10-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of Subscription.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _authorizationSource = DefineProperty<string>("AuthorizationSource", ["authorizationSource"], isOutput: true);
        _displayName = DefineProperty<string>("DisplayName", ["displayName"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _managedByTenants = DefineListProperty<ManagedByTenant>("ManagedByTenants", ["managedByTenants"], isOutput: true);
        _state = DefineProperty<SubscriptionState>("State", ["state"], isOutput: true);
        _subscriptionId = DefineProperty<string>("SubscriptionId", ["subscriptionId"], isOutput: true);
        _subscriptionPolicies = DefineModelProperty<SubscriptionPolicies>("SubscriptionPolicies", ["subscriptionPolicies"], isOutput: true);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"], isOutput: true);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
    }

    /// <summary>
    /// Supported Subscription resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2019-10-01.
        /// </summary>
        public static readonly string V2019_10_01 = "2019-10-01";

        /// <summary>
        /// 2019-09-01.
        /// </summary>
        public static readonly string V2019_09_01 = "2019-09-01";

        /// <summary>
        /// 2019-05-01.
        /// </summary>
        public static readonly string V2019_05_01 = "2019-05-01";

        /// <summary>
        /// 2019-04-01.
        /// </summary>
        public static readonly string V2019_04_01 = "2019-04-01";

        /// <summary>
        /// 2019-03-01.
        /// </summary>
        public static readonly string V2019_03_01 = "2019-03-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-09-01.
        /// </summary>
        public static readonly string V2018_09_01 = "2018-09-01";

        /// <summary>
        /// 2018-08-01.
        /// </summary>
        public static readonly string V2018_08_01 = "2018-08-01";

        /// <summary>
        /// 2018-07-01.
        /// </summary>
        public static readonly string V2018_07_01 = "2018-07-01";

        /// <summary>
        /// 2018-05-01.
        /// </summary>
        public static readonly string V2018_05_01 = "2018-05-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2018-01-01.
        /// </summary>
        public static readonly string V2018_01_01 = "2018-01-01";

        /// <summary>
        /// 2017-08-01.
        /// </summary>
        public static readonly string V2017_08_01 = "2017-08-01";

        /// <summary>
        /// 2017-06-01.
        /// </summary>
        public static readonly string V2017_06_01 = "2017-06-01";

        /// <summary>
        /// 2017-05-10.
        /// </summary>
        public static readonly string V2017_05_10 = "2017-05-10";

        /// <summary>
        /// 2017-05-01.
        /// </summary>
        public static readonly string V2017_05_01 = "2017-05-01";

        /// <summary>
        /// 2017-03-01.
        /// </summary>
        public static readonly string V2017_03_01 = "2017-03-01";

        /// <summary>
        /// 2016-09-01.
        /// </summary>
        public static readonly string V2016_09_01 = "2016-09-01";

        /// <summary>
        /// 2016-07-01.
        /// </summary>
        public static readonly string V2016_07_01 = "2016-07-01";

        /// <summary>
        /// 2016-06-01.
        /// </summary>
        public static readonly string V2016_06_01 = "2016-06-01";

        /// <summary>
        /// 2016-02-01.
        /// </summary>
        public static readonly string V2016_02_01 = "2016-02-01";

        /// <summary>
        /// 2015-11-01.
        /// </summary>
        public static readonly string V2015_11_01 = "2015-11-01";

        /// <summary>
        /// 2015-01-01.
        /// </summary>
        public static readonly string V2015_01_01 = "2015-01-01";
    }
}
