// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// RoleManagementPolicyAssignment.
/// </summary>
public partial class RoleManagementPolicyAssignment : ProvisionableResource
{
    /// <summary>
    /// The name of format {guid_guid} the role management policy assignment to
    /// upsert.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The policy id role management policy assignment.
    /// </summary>
    public BicepValue<ResourceIdentifier> PolicyId 
    {
        get { Initialize(); return _policyId!; }
        set { Initialize(); _policyId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _policyId;

    /// <summary>
    /// The role definition of management policy assignment.
    /// </summary>
    public BicepValue<ResourceIdentifier> RoleDefinitionId 
    {
        get { Initialize(); return _roleDefinitionId!; }
        set { Initialize(); _roleDefinitionId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _roleDefinitionId;

    /// <summary>
    /// The role management policy scope.
    /// </summary>
    public BicepValue<string> Scope 
    {
        get { Initialize(); return _scope!; }
        set { Initialize(); _scope!.Assign(value); }
    }
    private BicepValue<string>? _scope;

    /// <summary>
    /// The readonly computed rule applied to the policy.             Please
    /// note
    /// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyRule is
    /// the base class. According to the scenario, a derived class of the base
    /// class might need to be assigned here, or this property needs to be
    /// casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyApprovalRule,
    /// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyAuthenticationContextRule,
    /// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyEnablementRule,
    /// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyExpirationRule
    /// and
    /// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyNotificationRule.
    /// </summary>
    public BicepList<RoleManagementPolicyRule> EffectiveRules 
    {
        get { Initialize(); return _effectiveRules!; }
    }
    private BicepList<RoleManagementPolicyRule>? _effectiveRules;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Additional properties of scope, role definition and policy.
    /// </summary>
    public PolicyAssignmentProperties PolicyAssignmentProperties 
    {
        get { Initialize(); return _policyAssignmentProperties!; }
    }
    private PolicyAssignmentProperties? _policyAssignmentProperties;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new RoleManagementPolicyAssignment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the RoleManagementPolicyAssignment
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the RoleManagementPolicyAssignment.</param>
    public RoleManagementPolicyAssignment(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Authorization/roleManagementPolicyAssignments", resourceVersion ?? "2020-10-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// RoleManagementPolicyAssignment.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _policyId = DefineProperty<ResourceIdentifier>("PolicyId", ["properties", "policyId"]);
        _roleDefinitionId = DefineProperty<ResourceIdentifier>("RoleDefinitionId", ["properties", "roleDefinitionId"]);
        _scope = DefineProperty<string>("Scope", ["properties", "scope"]);
        _effectiveRules = DefineListProperty<RoleManagementPolicyRule>("EffectiveRules", ["properties", "effectiveRules"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _policyAssignmentProperties = DefineModelProperty<PolicyAssignmentProperties>("PolicyAssignmentProperties", ["properties", "policyAssignmentProperties"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported RoleManagementPolicyAssignment resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";
    }

    /// <summary>
    /// Creates a reference to an existing RoleManagementPolicyAssignment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the RoleManagementPolicyAssignment
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the RoleManagementPolicyAssignment.</param>
    /// <returns>The existing RoleManagementPolicyAssignment resource.</returns>
    public static RoleManagementPolicyAssignment FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
