// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// RoleAssignment.
/// </summary>
public partial class RoleAssignment : ProvisionableResource
{
    /// <summary>
    /// The name of the role assignment. It can be any valid GUID.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The principal ID.
    /// </summary>
    public BicepValue<Guid> PrincipalId 
    {
        get { Initialize(); return _principalId!; }
        set { Initialize(); _principalId!.Assign(value); }
    }
    private BicepValue<Guid>? _principalId;

    /// <summary>
    /// The role definition ID.
    /// </summary>
    public BicepValue<ResourceIdentifier> RoleDefinitionId 
    {
        get { Initialize(); return _roleDefinitionId!; }
        set { Initialize(); _roleDefinitionId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _roleDefinitionId;

    /// <summary>
    /// The conditions on the role assignment. This limits the resources it can
    /// be assigned to. e.g.:
    /// @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
    /// StringEqualsIgnoreCase &apos;foo_storage_container&apos;.
    /// </summary>
    public BicepValue<string> Condition 
    {
        get { Initialize(); return _condition!; }
        set { Initialize(); _condition!.Assign(value); }
    }
    private BicepValue<string>? _condition;

    /// <summary>
    /// Version of the condition. Currently the only accepted value is
    /// &apos;2.0&apos;.
    /// </summary>
    public BicepValue<string> ConditionVersion 
    {
        get { Initialize(); return _conditionVersion!; }
        set { Initialize(); _conditionVersion!.Assign(value); }
    }
    private BicepValue<string>? _conditionVersion;

    /// <summary>
    /// Id of the delegated managed identity resource.
    /// </summary>
    public BicepValue<ResourceIdentifier> DelegatedManagedIdentityResourceId 
    {
        get { Initialize(); return _delegatedManagedIdentityResourceId!; }
        set { Initialize(); _delegatedManagedIdentityResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _delegatedManagedIdentityResourceId;

    /// <summary>
    /// Description of role assignment.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// The principal type of the assigned principal ID.
    /// </summary>
    public BicepValue<RoleManagementPrincipalType> PrincipalType 
    {
        get { Initialize(); return _principalType!; }
        set { Initialize(); _principalType!.Assign(value); }
    }
    private BicepValue<RoleManagementPrincipalType>? _principalType;

    /// <summary>
    /// Id of the user who created the assignment.
    /// </summary>
    public BicepValue<string> CreatedBy 
    {
        get { Initialize(); return _createdBy!; }
    }
    private BicepValue<string>? _createdBy;

    /// <summary>
    /// Time it was created.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The role assignment scope.
    /// </summary>
    public BicepValue<string> Scope 
    {
        get { Initialize(); return _scope!; }
        set { Initialize(); _scope!.Assign(value); }
    }
    private BicepValue<string>? _scope;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Id of the user who updated the assignment.
    /// </summary>
    public BicepValue<string> UpdatedBy 
    {
        get { Initialize(); return _updatedBy!; }
    }
    private BicepValue<string>? _updatedBy;

    /// <summary>
    /// Time it was updated.
    /// </summary>
    public BicepValue<DateTimeOffset> UpdatedOn 
    {
        get { Initialize(); return _updatedOn!; }
    }
    private BicepValue<DateTimeOffset>? _updatedOn;

    /// <summary>
    /// Get the default value for the Name property.
    /// </summary>
    private partial BicepValue<string> GetNameDefaultValue();

    /// <summary>
    /// Creates a new RoleAssignment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the RoleAssignment resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the RoleAssignment.</param>
    public RoleAssignment(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Authorization/roleAssignments", resourceVersion ?? "2022-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RoleAssignment.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true, defaultValue: GetNameDefaultValue());
        _principalId = DefineProperty<Guid>("PrincipalId", ["properties", "principalId"], isRequired: true);
        _roleDefinitionId = DefineProperty<ResourceIdentifier>("RoleDefinitionId", ["properties", "roleDefinitionId"], isRequired: true);
        _condition = DefineProperty<string>("Condition", ["properties", "condition"]);
        _conditionVersion = DefineProperty<string>("ConditionVersion", ["properties", "conditionVersion"]);
        _delegatedManagedIdentityResourceId = DefineProperty<ResourceIdentifier>("DelegatedManagedIdentityResourceId", ["properties", "delegatedManagedIdentityResourceId"]);
        _description = DefineProperty<string>("Description", ["properties", "description"]);
        _principalType = DefineProperty<RoleManagementPrincipalType>("PrincipalType", ["properties", "principalType"]);
        _createdBy = DefineProperty<string>("CreatedBy", ["properties", "createdBy"], isOutput: true);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "createdOn"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _scope = DefineProperty<string>("Scope", ["scope"]);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _updatedBy = DefineProperty<string>("UpdatedBy", ["properties", "updatedBy"], isOutput: true);
        _updatedOn = DefineProperty<DateTimeOffset>("UpdatedOn", ["properties", "updatedOn"], isOutput: true);
    }

    /// <summary>
    /// Supported RoleAssignment resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2022-04-01.
        /// </summary>
        public static readonly string V2022_04_01 = "2022-04-01";

        /// <summary>
        /// 2018-07-01.
        /// </summary>
        public static readonly string V2018_07_01 = "2018-07-01";

        /// <summary>
        /// 2017-09-01.
        /// </summary>
        public static readonly string V2017_09_01 = "2017-09-01";

        /// <summary>
        /// 2017-05-01.
        /// </summary>
        public static readonly string V2017_05_01 = "2017-05-01";

        /// <summary>
        /// 2016-07-01.
        /// </summary>
        public static readonly string V2016_07_01 = "2016-07-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";
    }

    /// <summary>
    /// Creates a reference to an existing RoleAssignment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the RoleAssignment resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the RoleAssignment.</param>
    /// <returns>The existing RoleAssignment resource.</returns>
    public static RoleAssignment FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
