// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Resources;

/// <summary>
/// PolicyAssignment.
/// </summary>
public partial class PolicyAssignment : ProvisionableResource
{
    /// <summary>
    /// The name of the policy assignment.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// This message will be part of response in case of policy violation.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// The display name of the policy assignment.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// The policy assignment enforcement mode. Possible values are Default and
    /// DoNotEnforce.
    /// </summary>
    public BicepValue<EnforcementMode> EnforcementMode 
    {
        get { Initialize(); return _enforcementMode!; }
        set { Initialize(); _enforcementMode!.Assign(value); }
    }
    private BicepValue<EnforcementMode>? _enforcementMode;

    /// <summary>
    /// The policy&apos;s excluded scopes.
    /// </summary>
    public BicepList<string> ExcludedScopes 
    {
        get { Initialize(); return _excludedScopes!; }
        set { Initialize(); _excludedScopes!.Assign(value); }
    }
    private BicepList<string>? _excludedScopes;

    /// <summary>
    /// The location of the policy assignment. Only required when utilizing
    /// managed identity.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The managed identity associated with the policy assignment. Current
    /// supported identity types: None, SystemAssigned, UserAssigned.
    /// </summary>
    public ManagedServiceIdentity ManagedIdentity 
    {
        get { Initialize(); return _managedIdentity!; }
        set { Initialize(); AssignOrReplace(ref _managedIdentity, value); }
    }
    private ManagedServiceIdentity? _managedIdentity;

    /// <summary>
    /// The policy assignment metadata. Metadata is an open ended object and is
    /// typically a collection of key value pairs.                          To
    /// assign an object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> Metadata 
    {
        get { Initialize(); return _metadata!; }
        set { Initialize(); _metadata!.Assign(value); }
    }
    private BicepValue<BinaryData>? _metadata;

    /// <summary>
    /// The messages that describe why a resource is non-compliant with the
    /// policy.
    /// </summary>
    public BicepList<NonComplianceMessage> NonComplianceMessages 
    {
        get { Initialize(); return _nonComplianceMessages!; }
        set { Initialize(); _nonComplianceMessages!.Assign(value); }
    }
    private BicepList<NonComplianceMessage>? _nonComplianceMessages;

    /// <summary>
    /// The policy property value override.
    /// </summary>
    public BicepList<PolicyOverride> Overrides 
    {
        get { Initialize(); return _overrides!; }
        set { Initialize(); _overrides!.Assign(value); }
    }
    private BicepList<PolicyOverride>? _overrides;

    /// <summary>
    /// The parameter values for the assigned policy rule. The keys are the
    /// parameter names.
    /// </summary>
    public BicepDictionary<ArmPolicyParameterValue> Parameters 
    {
        get { Initialize(); return _parameters!; }
        set { Initialize(); _parameters!.Assign(value); }
    }
    private BicepDictionary<ArmPolicyParameterValue>? _parameters;

    /// <summary>
    /// The ID of the policy definition or policy set definition being assigned.
    /// </summary>
    public BicepValue<string> PolicyDefinitionId 
    {
        get { Initialize(); return _policyDefinitionId!; }
        set { Initialize(); _policyDefinitionId!.Assign(value); }
    }
    private BicepValue<string>? _policyDefinitionId;

    /// <summary>
    /// The resource selector list to filter policies by resource properties.
    /// </summary>
    public BicepList<ResourceSelector> ResourceSelectors 
    {
        get { Initialize(); return _resourceSelectors!; }
        set { Initialize(); _resourceSelectors!.Assign(value); }
    }
    private BicepList<ResourceSelector>? _resourceSelectors;

    /// <summary>
    /// Fully qualified resource ID for the resource. Ex -
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The scope for the policy assignment.
    /// </summary>
    public BicepValue<string> Scope 
    {
        get { Initialize(); return _scope!; }
    }
    private BicepValue<string>? _scope;

    /// <summary>
    /// Azure Resource Manager metadata containing createdBy and modifiedBy
    /// information.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new PolicyAssignment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PolicyAssignment resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PolicyAssignment.</param>
    public PolicyAssignment(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Authorization/policyAssignments", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PolicyAssignment.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _description = DefineProperty<string>("Description", ["properties", "description"]);
        _displayName = DefineProperty<string>("DisplayName", ["properties", "displayName"]);
        _enforcementMode = DefineProperty<EnforcementMode>("EnforcementMode", ["properties", "enforcementMode"]);
        _excludedScopes = DefineListProperty<string>("ExcludedScopes", ["properties", "notScopes"]);
        _location = DefineProperty<AzureLocation>("Location", ["location"]);
        _managedIdentity = DefineModelProperty<ManagedServiceIdentity>("ManagedIdentity", ["identity"]);
        _metadata = DefineProperty<BinaryData>("Metadata", ["properties", "metadata"]);
        _nonComplianceMessages = DefineListProperty<NonComplianceMessage>("NonComplianceMessages", ["properties", "nonComplianceMessages"]);
        _overrides = DefineListProperty<PolicyOverride>("Overrides", ["properties", "overrides"]);
        _parameters = DefineDictionaryProperty<ArmPolicyParameterValue>("Parameters", ["properties", "parameters"]);
        _policyDefinitionId = DefineProperty<string>("PolicyDefinitionId", ["properties", "policyDefinitionId"]);
        _resourceSelectors = DefineListProperty<ResourceSelector>("ResourceSelectors", ["properties", "resourceSelectors"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _scope = DefineProperty<string>("Scope", ["properties", "scope"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported PolicyAssignment resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2022-06-01.
        /// </summary>
        public static readonly string V2022_06_01 = "2022-06-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-08-01.
        /// </summary>
        public static readonly string V2020_08_01 = "2020-08-01";

        /// <summary>
        /// 2020-03-01.
        /// </summary>
        public static readonly string V2020_03_01 = "2020-03-01";

        /// <summary>
        /// 2019-09-01.
        /// </summary>
        public static readonly string V2019_09_01 = "2019-09-01";

        /// <summary>
        /// 2019-06-01.
        /// </summary>
        public static readonly string V2019_06_01 = "2019-06-01";

        /// <summary>
        /// 2019-01-01.
        /// </summary>
        public static readonly string V2019_01_01 = "2019-01-01";

        /// <summary>
        /// 2018-05-01.
        /// </summary>
        public static readonly string V2018_05_01 = "2018-05-01";

        /// <summary>
        /// 2018-03-01.
        /// </summary>
        public static readonly string V2018_03_01 = "2018-03-01";

        /// <summary>
        /// 2016-12-01.
        /// </summary>
        public static readonly string V2016_12_01 = "2016-12-01";

        /// <summary>
        /// 2016-04-01.
        /// </summary>
        public static readonly string V2016_04_01 = "2016-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing PolicyAssignment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PolicyAssignment resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PolicyAssignment.</param>
    /// <returns>The existing PolicyAssignment resource.</returns>
    public static PolicyAssignment FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this PolicyAssignment resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 128, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen | ResourceNameCharacters.Underscore | ResourceNameCharacters.Period | ResourceNameCharacters.Parentheses);
}
