// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ZoneMapping.
/// </summary>
public partial class ZoneMapping : ProvisionableConstruct
{
    /// <summary>
    /// Gets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Gets the Zones.
    /// </summary>
    public BicepList<string> Zones 
    {
        get { Initialize(); return _zones!; }
    }
    private BicepList<string>? _zones;

    /// <summary>
    /// Creates a new ZoneMapping.
    /// </summary>
    public ZoneMapping()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ZoneMapping.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _zones = DefineListProperty<string>("Zones", ["zones"], isOutput: true);
    }
}
