// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// High-level information about a Template Spec version.
/// </summary>
public partial class TemplateSpecVersionInfo : ProvisionableConstruct
{
    /// <summary>
    /// Template Spec version description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// The timestamp of when the version was created.
    /// </summary>
    public BicepValue<DateTimeOffset> TimeCreated 
    {
        get { Initialize(); return _timeCreated!; }
    }
    private BicepValue<DateTimeOffset>? _timeCreated;

    /// <summary>
    /// The timestamp of when the version was last modified.
    /// </summary>
    public BicepValue<DateTimeOffset> TimeModified 
    {
        get { Initialize(); return _timeModified!; }
    }
    private BicepValue<DateTimeOffset>? _timeModified;

    /// <summary>
    /// Creates a new TemplateSpecVersionInfo.
    /// </summary>
    public TemplateSpecVersionInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of TemplateSpecVersionInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _description = DefineProperty<string>("Description", ["description"], isOutput: true);
        _timeCreated = DefineProperty<DateTimeOffset>("TimeCreated", ["timeCreated"], isOutput: true);
        _timeModified = DefineProperty<DateTimeOffset>("TimeModified", ["timeModified"], isOutput: true);
    }
}
