// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Metadata pertaining to creation and last modification of the resource.
/// </summary>
public partial class SystemData : ProvisionableConstruct
{
    /// <summary>
    /// The identity that created the resource.
    /// </summary>
    public BicepValue<string> CreatedBy 
    {
        get { Initialize(); return _createdBy!; }
    }
    private BicepValue<string>? _createdBy;

    /// <summary>
    /// The type of identity that created the resource.
    /// </summary>
    public BicepValue<CreatedByType> CreatedByType 
    {
        get { Initialize(); return _createdByType!; }
    }
    private BicepValue<CreatedByType>? _createdByType;

    /// <summary>
    /// The timestamp of resource creation (UTC).
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// The identity that last modified the resource.
    /// </summary>
    public BicepValue<string> LastModifiedBy 
    {
        get { Initialize(); return _lastModifiedBy!; }
    }
    private BicepValue<string>? _lastModifiedBy;

    /// <summary>
    /// The type of identity that last modified the resource.
    /// </summary>
    public BicepValue<CreatedByType> LastModifiedByType 
    {
        get { Initialize(); return _lastModifiedByType!; }
    }
    private BicepValue<CreatedByType>? _lastModifiedByType;

    /// <summary>
    /// The timestamp of resource last modification (UTC).
    /// </summary>
    public BicepValue<DateTimeOffset> LastModifiedOn 
    {
        get { Initialize(); return _lastModifiedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastModifiedOn;

    /// <summary>
    /// Creates a new SystemData.
    /// </summary>
    public SystemData()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SystemData.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _createdBy = DefineProperty<string>("CreatedBy", ["createdBy"], isOutput: true);
        _createdByType = DefineProperty<CreatedByType>("CreatedByType", ["createdByType"], isOutput: true);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["createdAt"], isOutput: true);
        _lastModifiedBy = DefineProperty<string>("LastModifiedBy", ["lastModifiedBy"], isOutput: true);
        _lastModifiedByType = DefineProperty<CreatedByType>("LastModifiedByType", ["lastModifiedByType"], isOutput: true);
        _lastModifiedOn = DefineProperty<DateTimeOffset>("LastModifiedOn", ["lastModifiedAt"], isOutput: true);
    }
}
