// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Managed service identity (either system assigned, or none).
/// </summary>
public partial class SystemAssignedServiceIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The service principal ID of the system assigned identity. This property
    /// will only be provided for a system assigned identity.
    /// </summary>
    public BicepValue<Guid> PrincipalId 
    {
        get { Initialize(); return _principalId!; }
    }
    private BicepValue<Guid>? _principalId;

    /// <summary>
    /// The tenant ID of the system assigned identity. This property will only
    /// be provided for a system assigned identity.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Type of managed service identity (either system assigned, or none).
    /// </summary>
    public BicepValue<SystemAssignedServiceIdentityType> SystemAssignedServiceIdentityType 
    {
        get { Initialize(); return _systemAssignedServiceIdentityType!; }
        set { Initialize(); _systemAssignedServiceIdentityType!.Assign(value); }
    }
    private BicepValue<SystemAssignedServiceIdentityType>? _systemAssignedServiceIdentityType;

    /// <summary>
    /// Creates a new SystemAssignedServiceIdentity.
    /// </summary>
    public SystemAssignedServiceIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SystemAssignedServiceIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _principalId = DefineProperty<Guid>("PrincipalId", ["principalId"], isOutput: true);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
        _systemAssignedServiceIdentityType = DefineProperty<SystemAssignedServiceIdentityType>("SystemAssignedServiceIdentityType", ["type"]);
    }
}
