// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Subscription policies.
/// </summary>
public partial class SubscriptionPolicies : ProvisionableConstruct
{
    /// <summary>
    /// The subscription location placement ID. The ID indicates which regions
    /// are visible for a subscription. For example, a subscription with a
    /// location placement Id of Public_2014-09-01 has access to Azure public
    /// regions.
    /// </summary>
    public BicepValue<string> LocationPlacementId 
    {
        get { Initialize(); return _locationPlacementId!; }
    }
    private BicepValue<string>? _locationPlacementId;

    /// <summary>
    /// The subscription quota ID.
    /// </summary>
    public BicepValue<string> QuotaId 
    {
        get { Initialize(); return _quotaId!; }
    }
    private BicepValue<string>? _quotaId;

    /// <summary>
    /// The subscription spending limit.
    /// </summary>
    public BicepValue<SpendingLimit> SpendingLimit 
    {
        get { Initialize(); return _spendingLimit!; }
    }
    private BicepValue<SpendingLimit>? _spendingLimit;

    /// <summary>
    /// Creates a new SubscriptionPolicies.
    /// </summary>
    public SubscriptionPolicies()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SubscriptionPolicies.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _locationPlacementId = DefineProperty<string>("LocationPlacementId", ["locationPlacementId"], isOutput: true);
        _quotaId = DefineProperty<string>("QuotaId", ["quotaId"], isOutput: true);
        _spendingLimit = DefineProperty<SpendingLimit>("SpendingLimit", ["spendingLimit"], isOutput: true);
    }
}
