// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// The detail of a user.
/// </summary>
public partial class RoleManagementUserInfo : ProvisionableConstruct
{
    /// <summary>
    /// The type of user.
    /// </summary>
    public BicepValue<RoleManagementUserType> UserType 
    {
        get { Initialize(); return _userType!; }
        set { Initialize(); _userType!.Assign(value); }
    }
    private BicepValue<RoleManagementUserType>? _userType;

    /// <summary>
    /// The value indicating whether the user is a backup fallback approver.
    /// </summary>
    public BicepValue<bool> IsBackup 
    {
        get { Initialize(); return _isBackup!; }
        set { Initialize(); _isBackup!.Assign(value); }
    }
    private BicepValue<bool>? _isBackup;

    /// <summary>
    /// The object id of the user.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// The description of the user.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Creates a new RoleManagementUserInfo.
    /// </summary>
    public RoleManagementUserInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RoleManagementUserInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _userType = DefineProperty<RoleManagementUserType>("UserType", ["userType"]);
        _isBackup = DefineProperty<bool>("IsBackup", ["isBackup"]);
        _id = DefineProperty<string>("Id", ["id"]);
        _description = DefineProperty<string>("Description", ["description"]);
    }
}
