// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// The name of the entity last modified it.
/// </summary>
public partial class RoleManagementPrincipal : ProvisionableConstruct
{
    /// <summary>
    /// The id of the principal made changes.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// The name of the principal made changes.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// Type of the principal.
    /// </summary>
    public BicepValue<RoleManagementPrincipalType> PrincipalType 
    {
        get { Initialize(); return _principalType!; }
    }
    private BicepValue<RoleManagementPrincipalType>? _principalType;

    /// <summary>
    /// Email of principal.
    /// </summary>
    public BicepValue<string> Email 
    {
        get { Initialize(); return _email!; }
    }
    private BicepValue<string>? _email;

    /// <summary>
    /// Creates a new RoleManagementPrincipal.
    /// </summary>
    public RoleManagementPrincipal()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RoleManagementPrincipal.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"], isOutput: true);
        _displayName = DefineProperty<string>("DisplayName", ["displayName"], isOutput: true);
        _principalType = DefineProperty<RoleManagementPrincipalType>("PrincipalType", ["type"], isOutput: true);
        _email = DefineProperty<string>("Email", ["email"], isOutput: true);
    }
}
