// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// The role management policy rule target.
/// </summary>
public partial class RoleManagementPolicyRuleTarget : ProvisionableConstruct
{
    /// <summary>
    /// The caller of the setting.
    /// </summary>
    public BicepValue<string> Caller 
    {
        get { Initialize(); return _caller!; }
        set { Initialize(); _caller!.Assign(value); }
    }
    private BicepValue<string>? _caller;

    /// <summary>
    /// The type of operation.
    /// </summary>
    public BicepList<string> Operations 
    {
        get { Initialize(); return _operations!; }
        set { Initialize(); _operations!.Assign(value); }
    }
    private BicepList<string>? _operations;

    /// <summary>
    /// The assignment level to which rule is applied.
    /// </summary>
    public BicepValue<RoleManagementAssignmentLevel> Level 
    {
        get { Initialize(); return _level!; }
        set { Initialize(); _level!.Assign(value); }
    }
    private BicepValue<RoleManagementAssignmentLevel>? _level;

    /// <summary>
    /// The list of target objects.
    /// </summary>
    public BicepList<string> TargetObjects 
    {
        get { Initialize(); return _targetObjects!; }
        set { Initialize(); _targetObjects!.Assign(value); }
    }
    private BicepList<string>? _targetObjects;

    /// <summary>
    /// The list of inheritable settings.
    /// </summary>
    public BicepList<string> InheritableSettings 
    {
        get { Initialize(); return _inheritableSettings!; }
        set { Initialize(); _inheritableSettings!.Assign(value); }
    }
    private BicepList<string>? _inheritableSettings;

    /// <summary>
    /// The list of enforced settings.
    /// </summary>
    public BicepList<string> EnforcedSettings 
    {
        get { Initialize(); return _enforcedSettings!; }
        set { Initialize(); _enforcedSettings!.Assign(value); }
    }
    private BicepList<string>? _enforcedSettings;

    /// <summary>
    /// Creates a new RoleManagementPolicyRuleTarget.
    /// </summary>
    public RoleManagementPolicyRuleTarget()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// RoleManagementPolicyRuleTarget.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _caller = DefineProperty<string>("Caller", ["caller"]);
        _operations = DefineListProperty<string>("Operations", ["operations"]);
        _level = DefineProperty<RoleManagementAssignmentLevel>("Level", ["level"]);
        _targetObjects = DefineListProperty<string>("TargetObjects", ["targetObjects"]);
        _inheritableSettings = DefineListProperty<string>("InheritableSettings", ["inheritableSettings"]);
        _enforcedSettings = DefineListProperty<string>("EnforcedSettings", ["enforcedSettings"]);
    }
}
