// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// The role management policy rule.             Please note
/// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyRule is the
/// base class. According to the scenario, a derived class of the base class
/// might need to be assigned here, or this property needs to be casted to one
/// of the possible derived classes.             The available derived classes
/// include
/// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyApprovalRule,
/// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyAuthenticationContextRule,
/// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyEnablementRule,
/// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyExpirationRule
/// and
/// Azure.ResourceManager.Authorization.Models.RoleManagementPolicyNotificationRule.
/// </summary>
public partial class RoleManagementPolicyRule : ProvisionableConstruct
{
    /// <summary>
    /// The id of the rule.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// The target of the current rule.
    /// </summary>
    public RoleManagementPolicyRuleTarget Target 
    {
        get { Initialize(); return _target!; }
        set { Initialize(); AssignOrReplace(ref _target, value); }
    }
    private RoleManagementPolicyRuleTarget? _target;

    /// <summary>
    /// Creates a new RoleManagementPolicyRule.
    /// </summary>
    public RoleManagementPolicyRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RoleManagementPolicyRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"]);
        _target = DefineModelProperty<RoleManagementPolicyRuleTarget>("Target", ["target"]);
    }
}
