// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// The role management policy notification rule.
/// </summary>
public partial class RoleManagementPolicyNotificationRule : RoleManagementPolicyRule
{
    /// <summary>
    /// The type of notification.
    /// </summary>
    public BicepValue<NotificationDeliveryType> NotificationDeliveryType 
    {
        get { Initialize(); return _notificationDeliveryType!; }
        set { Initialize(); _notificationDeliveryType!.Assign(value); }
    }
    private BicepValue<NotificationDeliveryType>? _notificationDeliveryType;

    /// <summary>
    /// The notification level.
    /// </summary>
    public BicepValue<RoleManagementPolicyNotificationLevel> NotificationLevel 
    {
        get { Initialize(); return _notificationLevel!; }
        set { Initialize(); _notificationLevel!.Assign(value); }
    }
    private BicepValue<RoleManagementPolicyNotificationLevel>? _notificationLevel;

    /// <summary>
    /// The recipient type.
    /// </summary>
    public BicepValue<RoleManagementPolicyRecipientType> RecipientType 
    {
        get { Initialize(); return _recipientType!; }
        set { Initialize(); _recipientType!.Assign(value); }
    }
    private BicepValue<RoleManagementPolicyRecipientType>? _recipientType;

    /// <summary>
    /// The list of notification recipients.
    /// </summary>
    public BicepList<string> NotificationRecipients 
    {
        get { Initialize(); return _notificationRecipients!; }
        set { Initialize(); _notificationRecipients!.Assign(value); }
    }
    private BicepList<string>? _notificationRecipients;

    /// <summary>
    /// Determines if the notification will be sent to the recipient type
    /// specified in the policy rule.
    /// </summary>
    public BicepValue<bool> AreDefaultRecipientsEnabled 
    {
        get { Initialize(); return _areDefaultRecipientsEnabled!; }
        set { Initialize(); _areDefaultRecipientsEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _areDefaultRecipientsEnabled;

    /// <summary>
    /// Creates a new RoleManagementPolicyNotificationRule.
    /// </summary>
    public RoleManagementPolicyNotificationRule() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// RoleManagementPolicyNotificationRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("ruleType", ["ruleType"], defaultValue: "RoleManagementPolicyNotificationRule");
        _notificationDeliveryType = DefineProperty<NotificationDeliveryType>("NotificationDeliveryType", ["notificationType"]);
        _notificationLevel = DefineProperty<RoleManagementPolicyNotificationLevel>("NotificationLevel", ["notificationLevel"]);
        _recipientType = DefineProperty<RoleManagementPolicyRecipientType>("RecipientType", ["recipientType"]);
        _notificationRecipients = DefineListProperty<string>("NotificationRecipients", ["notificationRecipients"]);
        _areDefaultRecipientsEnabled = DefineProperty<bool>("AreDefaultRecipientsEnabled", ["isDefaultRecipientsEnabled"]);
    }
}
