// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// The role management policy expiration rule.
/// </summary>
public partial class RoleManagementPolicyExpirationRule : RoleManagementPolicyRule
{
    /// <summary>
    /// The value indicating whether expiration is required.
    /// </summary>
    public BicepValue<bool> IsExpirationRequired 
    {
        get { Initialize(); return _isExpirationRequired!; }
        set { Initialize(); _isExpirationRequired!.Assign(value); }
    }
    private BicepValue<bool>? _isExpirationRequired;

    /// <summary>
    /// The maximum duration of expiration in timespan.
    /// </summary>
    public BicepValue<TimeSpan> MaximumDuration 
    {
        get { Initialize(); return _maximumDuration!; }
        set { Initialize(); _maximumDuration!.Assign(value); }
    }
    private BicepValue<TimeSpan>? _maximumDuration;

    /// <summary>
    /// Creates a new RoleManagementPolicyExpirationRule.
    /// </summary>
    public RoleManagementPolicyExpirationRule() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// RoleManagementPolicyExpirationRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("ruleType", ["ruleType"], defaultValue: "RoleManagementPolicyExpirationRule");
        _isExpirationRequired = DefineProperty<bool>("IsExpirationRequired", ["isExpirationRequired"]);
        _maximumDuration = DefineProperty<TimeSpan>("MaximumDuration", ["maximumDuration"], format: "P");
    }
}
