// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// The role management policy authentication context rule.
/// </summary>
public partial class RoleManagementPolicyAuthenticationContextRule : RoleManagementPolicyRule
{
    /// <summary>
    /// The value indicating if rule is enabled.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// The claim value.
    /// </summary>
    public BicepValue<string> ClaimValue 
    {
        get { Initialize(); return _claimValue!; }
        set { Initialize(); _claimValue!.Assign(value); }
    }
    private BicepValue<string>? _claimValue;

    /// <summary>
    /// Creates a new RoleManagementPolicyAuthenticationContextRule.
    /// </summary>
    public RoleManagementPolicyAuthenticationContextRule() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// RoleManagementPolicyAuthenticationContextRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("ruleType", ["ruleType"], defaultValue: "RoleManagementPolicyAuthenticationContextRule");
        _isEnabled = DefineProperty<bool>("IsEnabled", ["isEnabled"]);
        _claimValue = DefineProperty<string>("ClaimValue", ["claimValue"]);
    }
}
