// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// The role management policy approval rule.
/// </summary>
public partial class RoleManagementPolicyApprovalRule : RoleManagementPolicyRule
{
    /// <summary>
    /// The approval setting.
    /// </summary>
    public RoleManagementApprovalSettings Settings 
    {
        get { Initialize(); return _settings!; }
        set { Initialize(); AssignOrReplace(ref _settings, value); }
    }
    private RoleManagementApprovalSettings? _settings;

    /// <summary>
    /// Creates a new RoleManagementPolicyApprovalRule.
    /// </summary>
    public RoleManagementPolicyApprovalRule() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// RoleManagementPolicyApprovalRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("ruleType", ["ruleType"], defaultValue: "RoleManagementPolicyApprovalRule");
        _settings = DefineModelProperty<RoleManagementApprovalSettings>("Settings", ["setting"]);
    }
}
