// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// The RoleManagementExpandedProperties.
/// </summary>
public partial class RoleManagementExpandedProperties : ProvisionableConstruct
{
    /// <summary>
    /// Id of the principal.
    /// </summary>
    public BicepValue<Guid> PrincipalId 
    {
        get { Initialize(); return _principalId!; }
    }
    private BicepValue<Guid>? _principalId;

    /// <summary>
    /// Display name of the principal.
    /// </summary>
    public BicepValue<string> PrincipalDisplayName 
    {
        get { Initialize(); return _principalDisplayName!; }
    }
    private BicepValue<string>? _principalDisplayName;

    /// <summary>
    /// Email id of the principal.
    /// </summary>
    public BicepValue<string> Email 
    {
        get { Initialize(); return _email!; }
    }
    private BicepValue<string>? _email;

    /// <summary>
    /// Type of the principal.
    /// </summary>
    public BicepValue<RoleManagementPrincipalType> PrincipalType 
    {
        get { Initialize(); return _principalType!; }
    }
    private BicepValue<RoleManagementPrincipalType>? _principalType;

    /// <summary>
    /// Id of the role definition.
    /// </summary>
    public BicepValue<ResourceIdentifier> RoleDefinitionId 
    {
        get { Initialize(); return _roleDefinitionId!; }
    }
    private BicepValue<ResourceIdentifier>? _roleDefinitionId;

    /// <summary>
    /// Display name of the role definition.
    /// </summary>
    public BicepValue<string> RoleDefinitionDisplayName 
    {
        get { Initialize(); return _roleDefinitionDisplayName!; }
    }
    private BicepValue<string>? _roleDefinitionDisplayName;

    /// <summary>
    /// The role type.
    /// </summary>
    public BicepValue<AuthorizationRoleType> RoleType 
    {
        get { Initialize(); return _roleType!; }
    }
    private BicepValue<AuthorizationRoleType>? _roleType;

    /// <summary>
    /// Scope id of the resource.
    /// </summary>
    public BicepValue<ResourceIdentifier> ScopeId 
    {
        get { Initialize(); return _scopeId!; }
    }
    private BicepValue<ResourceIdentifier>? _scopeId;

    /// <summary>
    /// Display name of the resource.
    /// </summary>
    public BicepValue<string> ScopeDisplayName 
    {
        get { Initialize(); return _scopeDisplayName!; }
    }
    private BicepValue<string>? _scopeDisplayName;

    /// <summary>
    /// Type of the scope.
    /// </summary>
    public BicepValue<RoleManagementScopeType> ScopeType 
    {
        get { Initialize(); return _scopeType!; }
    }
    private BicepValue<RoleManagementScopeType>? _scopeType;

    /// <summary>
    /// Creates a new RoleManagementExpandedProperties.
    /// </summary>
    public RoleManagementExpandedProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// RoleManagementExpandedProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _principalId = DefineProperty<Guid>("PrincipalId", ["principal", "id"], isOutput: true);
        _principalDisplayName = DefineProperty<string>("PrincipalDisplayName", ["principal", "displayName"], isOutput: true);
        _email = DefineProperty<string>("Email", ["principal", "email"], isOutput: true);
        _principalType = DefineProperty<RoleManagementPrincipalType>("PrincipalType", ["principal", "type"], isOutput: true);
        _roleDefinitionId = DefineProperty<ResourceIdentifier>("RoleDefinitionId", ["roleDefinition", "id"], isOutput: true);
        _roleDefinitionDisplayName = DefineProperty<string>("RoleDefinitionDisplayName", ["roleDefinition", "displayName"], isOutput: true);
        _roleType = DefineProperty<AuthorizationRoleType>("RoleType", ["roleDefinition", "type"], isOutput: true);
        _scopeId = DefineProperty<ResourceIdentifier>("ScopeId", ["scope", "id"], isOutput: true);
        _scopeDisplayName = DefineProperty<string>("ScopeDisplayName", ["scope", "displayName"], isOutput: true);
        _scopeType = DefineProperty<RoleManagementScopeType>("ScopeType", ["scope", "type"], isOutput: true);
    }
}
