// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// The approval stage.
/// </summary>
public partial class RoleManagementApprovalStage : ProvisionableConstruct
{
    /// <summary>
    /// The time in days when approval request would be timed out.
    /// </summary>
    public BicepValue<int> ApprovalStageTimeOutInDays 
    {
        get { Initialize(); return _approvalStageTimeOutInDays!; }
        set { Initialize(); _approvalStageTimeOutInDays!.Assign(value); }
    }
    private BicepValue<int>? _approvalStageTimeOutInDays;

    /// <summary>
    /// Determines whether approver need to provide justification for his
    /// decision.
    /// </summary>
    public BicepValue<bool> IsApproverJustificationRequired 
    {
        get { Initialize(); return _isApproverJustificationRequired!; }
        set { Initialize(); _isApproverJustificationRequired!.Assign(value); }
    }
    private BicepValue<bool>? _isApproverJustificationRequired;

    /// <summary>
    /// The time in minutes when the approval request would be escalated if the
    /// primary approver does not approve.
    /// </summary>
    public BicepValue<int> EscalationTimeInMinutes 
    {
        get { Initialize(); return _escalationTimeInMinutes!; }
        set { Initialize(); _escalationTimeInMinutes!.Assign(value); }
    }
    private BicepValue<int>? _escalationTimeInMinutes;

    /// <summary>
    /// The primary approver of the request.
    /// </summary>
    public BicepList<RoleManagementUserInfo> PrimaryApprovers 
    {
        get { Initialize(); return _primaryApprovers!; }
        set { Initialize(); _primaryApprovers!.Assign(value); }
    }
    private BicepList<RoleManagementUserInfo>? _primaryApprovers;

    /// <summary>
    /// The value determine whether escalation feature is enabled.
    /// </summary>
    public BicepValue<bool> IsEscalationEnabled 
    {
        get { Initialize(); return _isEscalationEnabled!; }
        set { Initialize(); _isEscalationEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEscalationEnabled;

    /// <summary>
    /// The escalation approver of the request.
    /// </summary>
    public BicepList<RoleManagementUserInfo> EscalationApprovers 
    {
        get { Initialize(); return _escalationApprovers!; }
        set { Initialize(); _escalationApprovers!.Assign(value); }
    }
    private BicepList<RoleManagementUserInfo>? _escalationApprovers;

    /// <summary>
    /// Creates a new RoleManagementApprovalStage.
    /// </summary>
    public RoleManagementApprovalStage()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RoleManagementApprovalStage.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _approvalStageTimeOutInDays = DefineProperty<int>("ApprovalStageTimeOutInDays", ["approvalStageTimeOutInDays"]);
        _isApproverJustificationRequired = DefineProperty<bool>("IsApproverJustificationRequired", ["isApproverJustificationRequired"]);
        _escalationTimeInMinutes = DefineProperty<int>("EscalationTimeInMinutes", ["escalationTimeInMinutes"]);
        _primaryApprovers = DefineListProperty<RoleManagementUserInfo>("PrimaryApprovers", ["primaryApprovers"]);
        _isEscalationEnabled = DefineProperty<bool>("IsEscalationEnabled", ["isEscalationEnabled"]);
        _escalationApprovers = DefineListProperty<RoleManagementUserInfo>("EscalationApprovers", ["escalationApprovers"]);
    }
}
