// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// Role definition permissions.
/// </summary>
public partial class RoleDefinitionPermission : ProvisionableConstruct
{
    /// <summary>
    /// Allowed actions.
    /// </summary>
    public BicepList<string> Actions 
    {
        get { Initialize(); return _actions!; }
        set { Initialize(); _actions!.Assign(value); }
    }
    private BicepList<string>? _actions;

    /// <summary>
    /// Denied actions.
    /// </summary>
    public BicepList<string> NotActions 
    {
        get { Initialize(); return _notActions!; }
        set { Initialize(); _notActions!.Assign(value); }
    }
    private BicepList<string>? _notActions;

    /// <summary>
    /// Allowed Data actions.
    /// </summary>
    public BicepList<string> DataActions 
    {
        get { Initialize(); return _dataActions!; }
        set { Initialize(); _dataActions!.Assign(value); }
    }
    private BicepList<string>? _dataActions;

    /// <summary>
    /// Denied Data actions.
    /// </summary>
    public BicepList<string> NotDataActions 
    {
        get { Initialize(); return _notDataActions!; }
        set { Initialize(); _notDataActions!.Assign(value); }
    }
    private BicepList<string>? _notDataActions;

    /// <summary>
    /// Creates a new RoleDefinitionPermission.
    /// </summary>
    public RoleDefinitionPermission()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RoleDefinitionPermission.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _actions = DefineListProperty<string>("Actions", ["actions"]);
        _notActions = DefineListProperty<string>("NotActions", ["notActions"]);
        _dataActions = DefineListProperty<string>("DataActions", ["dataActions"]);
        _notDataActions = DefineListProperty<string>("NotDataActions", ["notDataActions"]);
    }
}
