// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ResourceTypeAliasPattern.
/// </summary>
public partial class ResourceTypeAliasPattern : ProvisionableConstruct
{
    /// <summary>
    /// Gets the Phrase.
    /// </summary>
    public BicepValue<string> Phrase 
    {
        get { Initialize(); return _phrase!; }
    }
    private BicepValue<string>? _phrase;

    /// <summary>
    /// Gets the Variable.
    /// </summary>
    public BicepValue<string> Variable 
    {
        get { Initialize(); return _variable!; }
    }
    private BicepValue<string>? _variable;

    /// <summary>
    /// Gets the PatternType.
    /// </summary>
    public BicepValue<ResourceTypeAliasPatternType> PatternType 
    {
        get { Initialize(); return _patternType!; }
    }
    private BicepValue<ResourceTypeAliasPatternType>? _patternType;

    /// <summary>
    /// Creates a new ResourceTypeAliasPattern.
    /// </summary>
    public ResourceTypeAliasPattern()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ResourceTypeAliasPattern.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _phrase = DefineProperty<string>("Phrase", ["phrase"], isOutput: true);
        _variable = DefineProperty<string>("Variable", ["variable"], isOutput: true);
        _patternType = DefineProperty<ResourceTypeAliasPatternType>("PatternType", ["type"], isOutput: true);
    }
}
