// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ResourceTypeAliasPathMetadata.
/// </summary>
public partial class ResourceTypeAliasPathMetadata : ProvisionableConstruct
{
    /// <summary>
    /// Gets the TokenType.
    /// </summary>
    public BicepValue<ResourceTypeAliasPathTokenType> TokenType 
    {
        get { Initialize(); return _tokenType!; }
    }
    private BicepValue<ResourceTypeAliasPathTokenType>? _tokenType;

    /// <summary>
    /// Gets the Attributes.
    /// </summary>
    public BicepValue<ResourceTypeAliasPathAttributes> Attributes 
    {
        get { Initialize(); return _attributes!; }
    }
    private BicepValue<ResourceTypeAliasPathAttributes>? _attributes;

    /// <summary>
    /// Creates a new ResourceTypeAliasPathMetadata.
    /// </summary>
    public ResourceTypeAliasPathMetadata()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ResourceTypeAliasPathMetadata.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tokenType = DefineProperty<ResourceTypeAliasPathTokenType>("TokenType", ["type"], isOutput: true);
        _attributes = DefineProperty<ResourceTypeAliasPathAttributes>("Attributes", ["attributes"], isOutput: true);
    }
}
